/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.csv;

import hudson.FilePath;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.ReadCSVStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ReadCSVStepExecution
extends AbstractFileOrTextStepExecution<List<CSVRecord>> {
    private static final long serialVersionUID = 1L;
    private final transient ReadCSVStep step;

    protected ReadCSVStepExecution(@Nonnull ReadCSVStep step, @Nonnull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected List<CSVRecord> doRun() throws Exception {
        FilePath f;
        String fName = this.step.getDescriptor().getFunctionName();
        if (StringUtils.isNotBlank((String)this.step.getFile()) && StringUtils.isNotBlank((String)this.step.getText())) {
            throw new IllegalArgumentException(Messages.ReadCSVStepExecution_tooManyArguments(fName));
        }
        Reader reader = null;
        if (StringUtils.isNotBlank((String)this.step.getFile()) && (f = this.ws.child(this.step.getFile())).exists() && !f.isDirectory()) {
            reader = new InputStreamReader(f.read(), StandardCharsets.UTF_8);
        }
        if (StringUtils.isNotBlank((String)this.step.getText())) {
            reader = new StringReader(this.step.getText());
        }
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        if (reader != null) {
            CSVFormat format = this.step.getFormat();
            if (format == null) {
                format = CSVFormat.DEFAULT;
            }
            CSVParser parser = format.parse(reader);
            records.addAll(parser.getRecords());
        }
        return records;
    }
}

