/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.DumperOptions;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.Yaml;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WriteYamlStep
extends Step {
    private String file;
    private Object data;
    private String charset;
    private boolean overwrite;

    @DataBoundConstructor
    public WriteYamlStep(@Nonnull String file, @Nonnull Object data) {
        if (StringUtils.isBlank((String)file)) {
            throw new IllegalArgumentException("file parameter must be provided to writeYaml");
        }
        this.file = file;
        if (data == null) {
            throw new IllegalArgumentException("data parameter must be provided to writeYaml");
        }
        if (!this.isValidObjectType(data)) {
            throw new IllegalArgumentException("data parameter has invalid content (no-basic classes)");
        }
        this.data = data;
    }

    public String getFile() {
        return this.file;
    }

    public Object getData() {
        return this.data;
    }

    public String getCharset() {
        return this.charset;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    @DataBoundSetter
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    private boolean isValidObjectType(Object obj) {
        if (obj instanceof Boolean || obj instanceof Character || obj instanceof Number || obj instanceof String || obj instanceof URL || obj instanceof Calendar || obj instanceof Date || obj instanceof UUID || obj == null) {
            return true;
        }
        if (obj instanceof Map) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                if (this.isValidObjectType(entry.getKey()) && this.isValidObjectType(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Collection) {
            for (Object o : (Collection)obj) {
                if (this.isValidObjectType(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private transient WriteYamlStep step;

        protected Execution(@Nonnull StepContext context, WriteYamlStep step) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            FilePath path = ws.child(this.step.getFile());
            if (path.isDirectory()) {
                throw new FileNotFoundException(path.getRemote() + " is a directory.");
            }
            if (!this.step.isOverwrite() && path.exists()) {
                throw new FileAlreadyExistsException(path.getRemote());
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            Charset cs = StringUtils.isEmpty((String)this.step.getCharset()) ? Charset.forName("UTF-8") : Charset.forName(this.step.getCharset());
            try (OutputStreamWriter writer = new OutputStreamWriter(path.write(), cs);){
                yaml.dump(this.step.getData(), writer);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "writeYaml";
        }

        @Nonnull
        public String getDisplayName() {
            return "Write a yaml from an object.";
        }
    }
}

