// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.utility.steps.json;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code WriteJSONStep.DescriptorImpl.displayName}: {@code Write
     * JSON to a file in the workspace.}.
     * 
     * @return
     *     {@code Write JSON to a file in the workspace.}
     */
    public static String WriteJSONStep_DescriptorImpl_displayName() {
        return holder.format("WriteJSONStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code WriteJSONStep.DescriptorImpl.displayName}: {@code Write
     * JSON to a file in the workspace.}.
     * 
     * @return
     *     {@code Write JSON to a file in the workspace.}
     */
    public static Localizable _WriteJSONStep_DescriptorImpl_displayName() {
        return new Localizable(holder, "WriteJSONStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code ReadJSONStep.DescriptorImpl.displayName}: {@code Read JSON
     * from files in the workspace.}.
     * 
     * @return
     *     {@code Read JSON from files in the workspace.}
     */
    public static String ReadJSONStep_DescriptorImpl_displayName() {
        return holder.format("ReadJSONStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code ReadJSONStep.DescriptorImpl.displayName}: {@code Read JSON
     * from files in the workspace.}.
     * 
     * @return
     *     {@code Read JSON from files in the workspace.}
     */
    public static Localizable _ReadJSONStep_DescriptorImpl_displayName() {
        return new Localizable(holder, "ReadJSONStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code WriteJSONStepExecution_missingReturnTextAndFile}: {@code
     * You have to provide either file or returnText to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide either file or returnText to {0}.}
     */
    public static String WriteJSONStepExecution_missingReturnTextAndFile(Object arg0) {
        return holder.format("WriteJSONStepExecution_missingReturnTextAndFile", arg0);
    }

    /**
     * Key {@code WriteJSONStepExecution_missingReturnTextAndFile}: {@code
     * You have to provide either file or returnText to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide either file or returnText to {0}.}
     */
    public static Localizable _WriteJSONStepExecution_missingReturnTextAndFile(Object arg0) {
        return new Localizable(holder, "WriteJSONStepExecution_missingReturnTextAndFile", arg0);
    }

    /**
     * Key {@code WriteJSONStepExecution_bothReturnTextAndFile}: {@code You
     * cannot provide both returnText and file to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You cannot provide both returnText and file to {0}.}
     */
    public static String WriteJSONStepExecution_bothReturnTextAndFile(Object arg0) {
        return holder.format("WriteJSONStepExecution_bothReturnTextAndFile", arg0);
    }

    /**
     * Key {@code WriteJSONStepExecution_bothReturnTextAndFile}: {@code You
     * cannot provide both returnText and file to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You cannot provide both returnText and file to {0}.}
     */
    public static Localizable _WriteJSONStepExecution_bothReturnTextAndFile(Object arg0) {
        return new Localizable(holder, "WriteJSONStepExecution_bothReturnTextAndFile", arg0);
    }

    /**
     * Key {@code ReadJSONStepExecution.tooManyArguments}: {@code At most one
     * of file or text must be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code At most one of file or text must be provided to {0}.}
     */
    public static String ReadJSONStepExecution_tooManyArguments(Object arg0) {
        return holder.format("ReadJSONStepExecution.tooManyArguments", arg0);
    }

    /**
     * Key {@code ReadJSONStepExecution.tooManyArguments}: {@code At most one
     * of file or text must be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code At most one of file or text must be provided to {0}.}
     */
    public static Localizable _ReadJSONStepExecution_tooManyArguments(Object arg0) {
        return new Localizable(holder, "ReadJSONStepExecution.tooManyArguments", arg0);
    }

    /**
     * Key {@code JSONStepExecution.fileIsDirectory}: {@code {0} is a
     * directory.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a directory.}
     */
    public static String JSONStepExecution_fileIsDirectory(Object arg0) {
        return holder.format("JSONStepExecution.fileIsDirectory", arg0);
    }

    /**
     * Key {@code JSONStepExecution.fileIsDirectory}: {@code {0} is a
     * directory.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a directory.}
     */
    public static Localizable _JSONStepExecution_fileIsDirectory(Object arg0) {
        return new Localizable(holder, "JSONStepExecution.fileIsDirectory", arg0);
    }

    /**
     * Key {@code JSONStepExecution.fileNotFound}: {@code {0} does not
     * exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} does not exist.}
     */
    public static String JSONStepExecution_fileNotFound(Object arg0) {
        return holder.format("JSONStepExecution.fileNotFound", arg0);
    }

    /**
     * Key {@code JSONStepExecution.fileNotFound}: {@code {0} does not
     * exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} does not exist.}
     */
    public static Localizable _JSONStepExecution_fileNotFound(Object arg0) {
        return new Localizable(holder, "JSONStepExecution.fileNotFound", arg0);
    }

    /**
     * Key {@code WriteJSONStepExecution_missingJSON}: {@code You have to
     * provide a JSON object to save for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a JSON object to save for {0}.}
     */
    public static String WriteJSONStepExecution_missingJSON(Object arg0) {
        return holder.format("WriteJSONStepExecution_missingJSON", arg0);
    }

    /**
     * Key {@code WriteJSONStepExecution_missingJSON}: {@code You have to
     * provide a JSON object to save for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a JSON object to save for {0}.}
     */
    public static Localizable _WriteJSONStepExecution_missingJSON(Object arg0) {
        return new Localizable(holder, "WriteJSONStepExecution_missingJSON", arg0);
    }

}
