// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.utility.steps.csv;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CSVStepExecution.fileNotFound}: {@code {0} does not
     * exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} does not exist.}
     */
    public static String CSVStepExecution_fileNotFound(Object arg0) {
        return holder.format("CSVStepExecution.fileNotFound", arg0);
    }

    /**
     * Key {@code CSVStepExecution.fileNotFound}: {@code {0} does not
     * exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} does not exist.}
     */
    public static Localizable _CSVStepExecution_fileNotFound(Object arg0) {
        return new Localizable(holder, "CSVStepExecution.fileNotFound", arg0);
    }

    /**
     * Key {@code WriteCSVStep.DescriptorImpl.displayName}: {@code Write
     * content to a CSV file in the workspace.}.
     * 
     * @return
     *     {@code Write content to a CSV file in the workspace.}
     */
    public static String WriteCSVStep_DescriptorImpl_displayName() {
        return holder.format("WriteCSVStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code WriteCSVStep.DescriptorImpl.displayName}: {@code Write
     * content to a CSV file in the workspace.}.
     * 
     * @return
     *     {@code Write content to a CSV file in the workspace.}
     */
    public static Localizable _WriteCSVStep_DescriptorImpl_displayName() {
        return new Localizable(holder, "WriteCSVStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code CSVStepExecution.fileIsDirectory}: {@code {0} is a
     * directory.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a directory.}
     */
    public static String CSVStepExecution_fileIsDirectory(Object arg0) {
        return holder.format("CSVStepExecution.fileIsDirectory", arg0);
    }

    /**
     * Key {@code CSVStepExecution.fileIsDirectory}: {@code {0} is a
     * directory.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a directory.}
     */
    public static Localizable _CSVStepExecution_fileIsDirectory(Object arg0) {
        return new Localizable(holder, "CSVStepExecution.fileIsDirectory", arg0);
    }

    /**
     * Key {@code WriteCSVStepExecution.missingRecords}: {@code You have to
     * provide a list of records to save for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a list of records to save for {0}.}
     */
    public static String WriteCSVStepExecution_missingRecords(Object arg0) {
        return holder.format("WriteCSVStepExecution.missingRecords", arg0);
    }

    /**
     * Key {@code WriteCSVStepExecution.missingRecords}: {@code You have to
     * provide a list of records to save for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a list of records to save for {0}.}
     */
    public static Localizable _WriteCSVStepExecution_missingRecords(Object arg0) {
        return new Localizable(holder, "WriteCSVStepExecution.missingRecords", arg0);
    }

    /**
     * Key {@code ReadCSVStep.DescriptorImpl.displayName}: {@code Read
     * content from a CSV file in the workspace.}.
     * 
     * @return
     *     {@code Read content from a CSV file in the workspace.}
     */
    public static String ReadCSVStep_DescriptorImpl_displayName() {
        return holder.format("ReadCSVStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code ReadCSVStep.DescriptorImpl.displayName}: {@code Read
     * content from a CSV file in the workspace.}.
     * 
     * @return
     *     {@code Read content from a CSV file in the workspace.}
     */
    public static Localizable _ReadCSVStep_DescriptorImpl_displayName() {
        return new Localizable(holder, "ReadCSVStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code WriteCSVStepExecution.missingFile}: {@code You have to
     * provide a file for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a file for {0}.}
     */
    public static String WriteCSVStepExecution_missingFile(Object arg0) {
        return holder.format("WriteCSVStepExecution.missingFile", arg0);
    }

    /**
     * Key {@code WriteCSVStepExecution.missingFile}: {@code You have to
     * provide a file for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a file for {0}.}
     */
    public static Localizable _WriteCSVStepExecution_missingFile(Object arg0) {
        return new Localizable(holder, "WriteCSVStepExecution.missingFile", arg0);
    }

    /**
     * Key {@code ReadCSVStepExecution.tooManyArguments}: {@code Only one of
     * 'file' or 'text' arguments can be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Only one of 'file' or 'text' arguments can be provided to {0}.}
     */
    public static String ReadCSVStepExecution_tooManyArguments(Object arg0) {
        return holder.format("ReadCSVStepExecution.tooManyArguments", arg0);
    }

    /**
     * Key {@code ReadCSVStepExecution.tooManyArguments}: {@code Only one of
     * 'file' or 'text' arguments can be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Only one of 'file' or 'text' arguments can be provided to {0}.}
     */
    public static Localizable _ReadCSVStepExecution_tooManyArguments(Object arg0) {
        return new Localizable(holder, "ReadCSVStepExecution.tooManyArguments", arg0);
    }

}
