/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.tar;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileCallable;
import org.jenkinsci.plugins.pipeline.utility.steps.CompressStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.tar.TarStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class TarStepExecution
extends CompressStepExecution {
    private static final long serialVersionUID = -2607583480983180160L;
    private transient TarStep step;

    protected TarStepExecution(@NonNull TarStep step, @NonNull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected Void run() throws Exception {
        this.setCallable(new TarItFileCallable(this.step.getGlob(), this.step.getExclude(), this.step.isCompress(), this.step.isOverwrite(), this.step.isDefaultExcludes()));
        return super.run();
    }

    static class TarItFileCallable
    extends AbstractFileCallable<Integer> {
        final String glob;
        final String exclude;
        final boolean compress;
        final boolean overwrite;
        final boolean defaultExcludes;

        public TarItFileCallable(String glob, String exclude, boolean compress, boolean overwrite, boolean defaultExcludes) {
            this.glob = StringUtils.isBlank((String)glob) ? "**/*" : glob;
            this.exclude = exclude;
            this.compress = compress;
            this.overwrite = overwrite;
            this.defaultExcludes = defaultExcludes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            Path p = Paths.get(this.getDestination().getRemote(), new String[0]);
            if (this.overwrite && Files.exists(p, new LinkOption[0])) {
                Files.delete(p);
            }
            Archiver archiver = (this.compress ? ArchiverFactory.TARGZ : ArchiverFactory.TAR).create(this.getDestination().write());
            FileSet fileSet = Util.createFileSet((File)dir, (String)this.glob, (String)this.exclude);
            fileSet.setDefaultexcludes(this.defaultExcludes);
            DirectoryScanner scanner = fileSet.getDirectoryScanner(new Project());
            try {
                for (String path : scanner.getIncludedFiles()) {
                    File toArchive = new File(dir, path).getCanonicalFile();
                    if (Files.isSameFile(toArchive.toPath(), p)) continue;
                    archiver.visit(toArchive, path);
                }
            }
            finally {
                archiver.close();
            }
            return archiver.countEntries();
        }
    }
}

