/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStep;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepDescriptorImpl;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class ReadYamlStep
extends AbstractFileOrTextStep {
    public static final int HARDCODED_CEILING_MAX_ALIASES_FOR_COLLECTIONS = 1000;
    public static final int LIBRARY_DEFAULT_MAX_ALIASES_FOR_COLLECTIONS = new LoaderOptions().getMaxAliasesForCollections();
    public static final String MAX_MAX_ALIASES_PROPERTY = ReadYamlStep.class.getName() + ".MAX_MAX_ALIASES_FOR_COLLECTIONS";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Non final so that an admin can adjust the value through the groovy script console without restarting the instance.")
    private static int MAX_MAX_ALIASES_FOR_COLLECTIONS = ReadYamlStep.setMaxMaxAliasesForCollections(Integer.getInteger(MAX_MAX_ALIASES_PROPERTY, LIBRARY_DEFAULT_MAX_ALIASES_FOR_COLLECTIONS));
    public static final String DEFAULT_MAX_ALIASES_PROPERTY = ReadYamlStep.class.getName() + ".DEFAULT_MAX_ALIASES_FOR_COLLECTIONS";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Non final so that an admin can adjust the value through the groovy script console without restarting the instance.")
    private static int DEFAULT_MAX_ALIASES_FOR_COLLECTIONS = ReadYamlStep.setDefaultMaxAliasesForCollections(Integer.getInteger(DEFAULT_MAX_ALIASES_PROPERTY, -1));
    private int maxAliasesForCollections = -1;

    @DataBoundConstructor
    public ReadYamlStep() {
    }

    public static int setMaxMaxAliasesForCollections(int maxMaxAliasesForCollections) {
        MAX_MAX_ALIASES_FOR_COLLECTIONS = Math.min(maxMaxAliasesForCollections, 1000);
        return MAX_MAX_ALIASES_FOR_COLLECTIONS;
    }

    public static int getMaxMaxAliasesForCollections() {
        return MAX_MAX_ALIASES_FOR_COLLECTIONS;
    }

    public static int setDefaultMaxAliasesForCollections(int defaultMaxAliasesForCollections) {
        if (defaultMaxAliasesForCollections > 1000) {
            throw new IllegalArgumentException(defaultMaxAliasesForCollections + " > 1000. Hardcoded upper limit breached. Reduce the required DEFAULT_MAX_ALIASES_FOR_COLLECTIONS or convince the plugin maintainers to increase the HARDCODED_CEILING_MAX_ALIASES_FOR_COLLECTIONS property (added to stop people shooting themselves in the foot).");
        }
        if (defaultMaxAliasesForCollections > MAX_MAX_ALIASES_FOR_COLLECTIONS) {
            throw new IllegalArgumentException(defaultMaxAliasesForCollections + " > " + MAX_MAX_ALIASES_FOR_COLLECTIONS + ". Reduce the required DEFAULT_MAX_ALIASES_FOR_COLLECTIONS or convince your administrator to increase the max allowed value with the system property \"" + MAX_MAX_ALIASES_PROPERTY + "\"");
        }
        DEFAULT_MAX_ALIASES_FOR_COLLECTIONS = defaultMaxAliasesForCollections;
        return DEFAULT_MAX_ALIASES_FOR_COLLECTIONS;
    }

    public static int getDefaultMaxAliasesForCollections() {
        return DEFAULT_MAX_ALIASES_FOR_COLLECTIONS;
    }

    public int getMaxAliasesForCollections() {
        return this.maxAliasesForCollections;
    }

    @DataBoundSetter
    public void setMaxAliasesForCollections(int maxAliasesForCollections) {
        if (maxAliasesForCollections > MAX_MAX_ALIASES_FOR_COLLECTIONS) {
            throw new IllegalArgumentException(maxAliasesForCollections + " > " + MAX_MAX_ALIASES_FOR_COLLECTIONS + ". Reduce the aliases in your yaml or convince your administrator to increase the max allowed value with the system property \"" + MAX_MAX_ALIASES_PROPERTY + "\"");
        }
        this.maxAliasesForCollections = maxAliasesForCollections;
    }

    public StepExecution start(StepContext context) throws Exception {
        int ac = -1;
        if (this.maxAliasesForCollections >= 0) {
            ac = this.maxAliasesForCollections;
        } else if (DEFAULT_MAX_ALIASES_FOR_COLLECTIONS >= 0) {
            ac = DEFAULT_MAX_ALIASES_FOR_COLLECTIONS;
        }
        return new Execution(this, context, ac);
    }

    public static class Execution
    extends AbstractFileOrTextStepExecution<Object> {
        private static final long serialVersionUID = 1L;
        private transient ReadYamlStep step;
        private final int maxAliasesForCollections;

        protected Execution(@NonNull ReadYamlStep step, @NonNull StepContext context, int maxAliasesForCollections) {
            super(step, context);
            this.step = step;
            this.maxAliasesForCollections = maxAliasesForCollections;
        }

        @Override
        protected Object doRun() throws Exception {
            Object yamlText = "";
            if (!StringUtils.isBlank((String)this.step.getFile())) {
                FilePath path = this.ws.child(this.step.getFile());
                if (!path.exists()) {
                    throw new FileNotFoundException(path.getRemote() + " does not exist.");
                }
                if (path.isDirectory()) {
                    throw new FileNotFoundException(path.getRemote() + " is a directory.");
                }
                try (UnicodeReader reader = new UnicodeReader(path.read());){
                    yamlText = IOUtils.toString((Reader)reader);
                }
            }
            if (!StringUtils.isBlank((String)this.step.getText())) {
                yamlText = (String)yamlText + System.getProperty("line.separator") + this.step.getText();
            }
            Iterable yaml = this.newYaml().loadAll((String)yamlText);
            LinkedList result = new LinkedList();
            for (Object data : yaml) {
                result.add(data);
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new ByteArrayOutputStream());){
                out.writeObject(result);
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }

        protected Yaml newYaml() {
            if (this.maxAliasesForCollections >= 0) {
                LoaderOptions loaderOptions = new LoaderOptions();
                loaderOptions.setMaxAliasesForCollections(this.maxAliasesForCollections);
                Representer representer = new Representer(new DumperOptions());
                DumperOptions dumperOptions = new DumperOptions();
                dumperOptions.setDefaultFlowStyle(representer.getDefaultFlowStyle());
                dumperOptions.setDefaultScalarStyle(representer.getDefaultScalarStyle());
                dumperOptions.setAllowReadOnlyProperties(representer.getPropertyUtils().isAllowReadOnlyProperties());
                dumperOptions.setTimeZone(representer.getTimeZone());
                return new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()), representer, dumperOptions, loaderOptions);
            }
            return new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFileOrTextStepDescriptorImpl {
        public String getFunctionName() {
            return "readYaml";
        }

        @NonNull
        public String getDisplayName() {
            return "Read yaml from files in the workspace or text.";
        }
    }
}

