/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.zip;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileDecompressStep;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.UnZipStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class UnZipStep
extends AbstractFileDecompressStep {
    private String charset;
    private boolean read = false;

    @DataBoundConstructor
    public UnZipStep(String zipFile) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)zipFile)) {
            throw new Descriptor.FormException("Can not be empty", "zipFile");
        }
        this.setFile(zipFile);
    }

    public String getZipFile() {
        return this.getFile();
    }

    public boolean isRead() {
        return this.read;
    }

    @DataBoundSetter
    public void setRead(boolean read) {
        this.read = read;
    }

    public String getCharset() {
        return this.charset != null ? this.charset : "UTF-8";
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = charset.trim().isEmpty() ? "UTF-8" : charset;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new UnZipStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "unzip";
        }

        @NonNull
        public String getDisplayName() {
            return "Extract Zip file";
        }
    }
}

