/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.tar;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileCallable;
import org.jenkinsci.plugins.pipeline.utility.steps.DecompressStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.tar.UnTarStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class UnTarStepExecution
extends DecompressStepExecution {
    private static final long serialVersionUID = -7225291403337927553L;
    private transient UnTarStep step;

    protected UnTarStepExecution(@NonNull UnTarStep step, @NonNull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected Object run() throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        if (this.step.isTest()) {
            this.setCallable(new TestTarFileCallable(listener));
        } else {
            this.setCallable(new UnTarFileCallable(listener, this.step.getGlob(), this.step.isQuiet()));
        }
        return super.run();
    }

    static class TestTarFileCallable
    extends AbstractFileCallable<Boolean> {
        private TaskListener listener;

        public TestTarFileCallable(TaskListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            Serializable serializable;
            PrintStream logger = this.listener.getLogger();
            FileInputStream fileStream = new FileInputStream(f);
            FileChannel fileChannel = fileStream.getChannel();
            logger.printf("Checking %d bytes in %s%n", f.length(), f.getAbsolutePath());
            byte[] signature = new byte[2];
            try {
                fileStream.read(signature);
                fileChannel.position(0L);
            }
            catch (IOException exception) {
                fileStream.close();
                this.listener.error("Error validating tar/tgz file: " + exception.getMessage());
                Boolean bl = false;
                return bl;
            }
            finally {
                logger.flush();
            }
            FileInputStream inputStream = fileStream;
            if (GzipCompressorInputStream.matches((byte[])signature, (int)signature.length)) {
                try {
                    byte[] buffer;
                    inputStream = new GzipCompressorInputStream((InputStream)inputStream);
                    int nRead = -1;
                    while ((nRead = ((InputStream)inputStream).read(buffer = new byte[4096])) >= 0) {
                    }
                    fileChannel.position(0L);
                }
                catch (IOException exception) {
                    ((InputStream)inputStream).close();
                    this.listener.error("Error validating tgz file: " + exception.getMessage());
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    logger.flush();
                }
            }
            try {
                TarArchiveInputStream tarStream = new TarArchiveInputStream((InputStream)inputStream);
                serializable = null;
                try {
                    TarArchiveEntry entry;
                    while ((entry = tarStream.getNextTarEntry()) != null) {
                        if (entry.isCheckSumOK()) continue;
                        throw new IOException("Not a tar archive");
                    }
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (tarStream != null) {
                        if (serializable != null) {
                            try {
                                tarStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            tarStream.close();
                        }
                    }
                }
            }
            catch (IOException exception) {
                this.listener.error("Error validating tar file: " + exception.getMessage());
                serializable = Boolean.valueOf(false);
                return serializable;
            }
            finally {
                logger.flush();
            }
            return true;
        }
    }

    public static class UnTarFileCallable
    extends AbstractFileCallable<Void> {
        private final TaskListener listener;
        private final String glob;
        private final boolean quiet;

        public UnTarFileCallable(TaskListener listener, String glob, boolean quiet) {
            this.listener = listener;
            this.glob = glob;
            this.quiet = quiet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File tarFile, VirtualChannel channel) throws IOException, InterruptedException {
            PrintStream logger = this.listener.getLogger();
            boolean doGlob = !StringUtils.isBlank((String)this.glob);
            FileInputStream fileStream = new FileInputStream(tarFile);
            try {
                fileStream = new GzipCompressorInputStream((InputStream)fileStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getDestination().mkdirs();
            try (TarArchiveInputStream tarStream = new TarArchiveInputStream((InputStream)fileStream);){
                TarArchiveEntry entry;
                logger.println("Extracting from " + tarFile.getAbsolutePath());
                Integer fileCount = 0;
                while ((entry = tarStream.getNextTarEntry()) != null) {
                    if (doGlob && !this.matches(entry.getName(), this.glob)) continue;
                    FilePath f = this.getDestination().child(entry.getName());
                    if (entry.isDirectory()) {
                        f.mkdirs();
                        continue;
                    }
                    Integer n = fileCount;
                    Integer n2 = fileCount = Integer.valueOf(fileCount + 1);
                    if (!this.quiet) {
                        logger.printf("Extracting: %s -> %s%n", entry.getName(), f.getRemote());
                    }
                    if (entry.isCheckSumOK()) {
                        OutputStream outputStream = f.write();
                        IOUtils.copy((InputStream)tarStream, (OutputStream)outputStream);
                        outputStream.close();
                        continue;
                    }
                    throw new IOException("Not a tar archive");
                }
                logger.printf("Extracted: %d files%n", fileCount);
            }
            finally {
                logger.flush();
            }
            return null;
        }

        boolean matches(String path, String glob) {
            String safeGlob = glob.replace('/', File.separatorChar);
            String safePath = path.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safeGlob, (String)safePath);
        }
    }
}

