/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.maven;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WriteMavenPomStep
extends Step {
    private String file;
    private final transient Model model;

    @DataBoundConstructor
    public WriteMavenPomStep(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non-null");
        }
        this.model = model;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    @CheckForNull
    public Model getModel() {
        return this.model;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private transient WriteMavenPomStep step;

        protected Execution(@NonNull WriteMavenPomStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            FilePath path = !StringUtils.isBlank((String)this.step.getFile()) ? ws.child(this.step.getFile()) : ws.child("pom.xml");
            if (path.isDirectory()) {
                throw new FileNotFoundException(path.getRemote() + " is a directory.");
            }
            Model model = this.step.getModel();
            if (model == null) {
                throw new AbortException("The specified Maven Model is null. Probably Pipeline has been restarted, and the command is invoked outside @NonCPS Context (JENKINS-50633)");
            }
            try (OutputStream os = path.write();){
                new MavenXpp3Writer().write(os, model);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String getFunctionName() {
            return "writeMavenPom";
        }

        @NonNull
        public String getDisplayName() {
            return "Write a maven project file.";
        }
    }
}

