/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileCallable;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileCompressStep;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public abstract class CompressStepExecution
extends SynchronousNonBlockingStepExecution<Void> {
    private transient AbstractFileCallable<Integer> callable;
    private final transient AbstractFileCompressStep step;

    protected CompressStepExecution(@NonNull AbstractFileCompressStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    protected void setCallable(AbstractFileCallable callable) {
        this.callable = callable;
    }

    protected Void run() throws Exception {
        FilePath destination;
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        PrintStream logger = listener.getLogger();
        assert (logger != null);
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        FilePath source = ws;
        if (!StringUtils.isBlank((String)this.step.getDir())) {
            source = ws.child(this.step.getDir());
            if (!source.exists()) {
                throw new IOException(source.getRemote() + " does not exist.");
            }
            if (!source.isDirectory()) {
                throw new IOException(source.getRemote() + " is not a directory.");
            }
        }
        if ((destination = ws.child(this.step.getFile())).exists() && !this.step.isOverwrite()) {
            throw new IOException(destination.getRemote() + " exists.");
        }
        logger.print("Compress " + source.getRemote());
        if (!StringUtils.isBlank((String)this.step.getGlob()) || !StringUtils.isBlank((String)this.step.getExclude())) {
            logger.print(" filtered by [" + this.step.getGlob() + "] - [" + this.step.getExclude() + "]");
        }
        logger.println(" to " + destination.getRemote());
        this.callable.setDestination(destination);
        Integer count = (Integer)source.act(this.callable);
        logger.println("Compressed " + count + " entries.");
        if (this.step.isArchive()) {
            Run build = (Run)this.getContext().get(Run.class);
            if (build == null) {
                throw new MissingContextVariableException(Run.class);
            }
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            if (launcher == null) {
                throw new MissingContextVariableException(Launcher.class);
            }
            logger.println("Archiving " + destination.getRemote());
            HashMap<String, String> files = new HashMap<String, String>();
            String s = this.step.getFile().replace('\\', '/');
            files.put(s, s);
            build.pickArtifactManager().archive(ws, launcher, (BuildListener)new BuildListenerAdapter(listener), files);
        }
        return null;
    }
}

