/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.util.VersionNumber;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.Messages;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CompareVersionsStep
extends Step {
    private final String v1;
    private final String v2;
    private boolean failIfEmpty = false;

    @DataBoundConstructor
    public CompareVersionsStep(String v1, String v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    public String getV1() {
        return this.v1;
    }

    public String getV2() {
        return this.v2;
    }

    public boolean isFailIfEmpty() {
        return this.failIfEmpty;
    }

    @DataBoundSetter
    public void setFailIfEmpty(boolean failIfEmpty) {
        this.failIfEmpty = failIfEmpty;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExecutionImpl(context, this.v1, this.v2, this.failIfEmpty);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String getFunctionName() {
            return "compareVersions";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.CompareVersionsStep_DisplayName();
        }
    }

    public static class ExecutionImpl
    extends SynchronousStepExecution<Integer> {
        private final String v1;
        private final String v2;
        private final boolean failIfEmpty;

        protected ExecutionImpl(@NonNull StepContext context, String v1, String v2, boolean failIfEmpty) {
            super(context);
            this.v1 = v1;
            this.v2 = v2;
            this.failIfEmpty = failIfEmpty;
        }

        protected Integer run() throws Exception {
            if (StringUtils.isEmpty((String)this.v1) && StringUtils.isEmpty((String)this.v2)) {
                if (this.failIfEmpty) {
                    throw new AbortException("Both parameters are empty.");
                }
                return 0;
            }
            if (StringUtils.isEmpty((String)this.v1)) {
                if (this.failIfEmpty) {
                    throw new AbortException("v1 is empty.");
                }
                return -1;
            }
            if (StringUtils.isEmpty((String)this.v2)) {
                if (this.failIfEmpty) {
                    throw new AbortException("v2 is empty.");
                }
                return 1;
            }
            VersionNumber vn1 = new VersionNumber(this.v1);
            VersionNumber vn2 = new VersionNumber(this.v2);
            return vn1.compareTo(vn2);
        }
    }
}

