/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.json;

import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.json.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.json.WriteJSONStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class WriteJSONStepExecution
extends SynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    private transient WriteJSONStep step;

    protected WriteJSONStepExecution(@Nonnull WriteJSONStep step, @Nonnull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        if (this.step.getJson() == null) {
            throw new IllegalArgumentException(Messages.WriteJSONStepExecution_missingJSON(this.step.getDescriptor().getFunctionName()));
        }
        if (StringUtils.isBlank((String)this.step.getFile())) {
            throw new IllegalArgumentException(Messages.WriteJSONStepExecution_missingFile(this.step.getDescriptor().getFunctionName()));
        }
        FilePath path = ws.child(this.step.getFile());
        if (path.isDirectory()) {
            throw new FileNotFoundException(Messages.JSONStepExecution_fileIsDirectory(path.getRemote()));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(path.write(), "UTF-8");){
            if (this.step.getPretty() > 0) {
                writer.write(this.step.getJson().toString(this.step.getPretty()));
            } else {
                this.step.getJson().write((Writer)writer);
            }
        }
        return null;
    }
}

