/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.json;

import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.inject.Inject;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.json.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.json.ReadJSONStep;

public class ReadJSONStepExecution
extends AbstractFileOrTextStepExecution<JSON> {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient ReadJSONStep step;

    @Override
    protected JSON doRun() throws Exception {
        String fName = this.step.getDescriptor().getFunctionName();
        if (StringUtils.isNotBlank((String)this.step.getFile()) && StringUtils.isNotBlank((String)this.step.getText())) {
            throw new IllegalArgumentException(Messages.ReadJSONStepExecution_tooManyArguments(fName));
        }
        JSON json = null;
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            FilePath f = this.ws.child(this.step.getFile());
            if (f.exists() && !f.isDirectory()) {
                try (InputStream is = f.read();){
                    json = JSONSerializer.toJSON((Object)IOUtils.toString((InputStream)is));
                }
            } else {
                if (f.isDirectory()) {
                    throw new IllegalArgumentException(Messages.JSONStepExecution_fileIsDirectory(f.getRemote()));
                }
                if (!f.exists()) {
                    throw new FileNotFoundException(Messages.JSONStepExecution_fileNotFound(f.getRemote()));
                }
            }
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            json = JSONSerializer.toJSON((Object)this.step.getText().trim());
        }
        return json;
    }
}

