/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.DumperOptions;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.Yaml;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class WriteYamlStep
extends AbstractStepImpl {
    private String file;
    private Object data;

    @DataBoundConstructor
    public WriteYamlStep(@Nonnull String file, @Nonnull Object data) {
        if (file == null || StringUtils.isBlank((String)file)) {
            throw new IllegalArgumentException("file parameter must be provided to writeYaml");
        }
        this.file = file;
        if (data == null) {
            throw new IllegalArgumentException("data parameter must be provided to writeYaml");
        }
        if (!this.isValidObjectType(data)) {
            throw new IllegalArgumentException("data parameter has invalid content (no-basic classes)");
        }
        this.data = data;
    }

    public String getFile() {
        return this.file;
    }

    public Object getData() {
        return this.data;
    }

    private boolean isValidObjectType(Object obj) {
        if (obj instanceof Boolean || obj instanceof Character || obj instanceof Number || obj instanceof String || obj instanceof URL || obj instanceof Calendar || obj instanceof Date || obj instanceof UUID || obj == null) {
            return true;
        }
        if (obj instanceof Map) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                if (this.isValidObjectType(entry.getKey()) && this.isValidObjectType(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Collection) {
            for (Object o : (Collection)obj) {
                if (this.isValidObjectType(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @Inject
        private transient WriteYamlStep step;

        protected Void run() throws Exception {
            FilePath path = this.ws.child(this.step.getFile());
            if (path.exists()) {
                throw new FileAlreadyExistsException(path.getRemote() + " already exist.");
            }
            if (path.isDirectory()) {
                throw new FileNotFoundException(path.getRemote() + " is a directory.");
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            try (OutputStreamWriter writer = new OutputStreamWriter(path.write());){
                yaml.dump(this.step.getData(), writer);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "writeYaml";
        }

        public String getDisplayName() {
            return "Write a yaml from an object.";
        }
    }
}

