/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.ReadPropertiesStep;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class ReadPropertiesStepExecution
extends AbstractFileOrTextStepExecution<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    @StepContextParameter
    private transient TaskListener listener;
    @Inject
    private transient ReadPropertiesStep step;

    @Override
    protected Map<String, Object> doRun() throws Exception {
        PrintStream logger = this.listener.getLogger();
        Properties properties = new Properties();
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            FilePath f = this.ws.child(this.step.getFile());
            if (f.exists() && !f.isDirectory()) {
                try (InputStream is = f.read();){
                    properties.load(is);
                }
            } else if (f.isDirectory()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" is a directory, omitting from properties gathering");
            } else if (!f.exists()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" does not exist, omitting from properties gathering");
            }
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            StringReader sr = new StringReader(this.step.getText());
            properties.load(sr);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.addAll(this.step.getDefaults(), result);
        this.addAll(properties, result);
        return result;
    }

    private void addAll(Map src, Map<String, Object> dst) {
        if (src == null) {
            return;
        }
        for (Map.Entry e : src.entrySet()) {
            dst.put(e.getKey() != null ? e.getKey().toString() : null, e.getValue());
        }
    }
}

