/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf.mf;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.jar.Manifest;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.mf.ReadManifestStep;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.mf.SimpleManifest;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.UnZipStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class ReadManifestStepExecution
extends AbstractSynchronousNonBlockingStepExecution<SimpleManifest> {
    private static final long serialVersionUID = 1L;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FilePath ws;
    @Inject
    private transient ReadManifestStep step;

    protected SimpleManifest run() throws Exception {
        if (StringUtils.isBlank((String)this.step.getFile()) && StringUtils.isBlank((String)this.step.getText())) {
            throw new IllegalArgumentException("Need to specify either file or text to readManifest.");
        }
        if (!StringUtils.isBlank((String)this.step.getFile()) && !StringUtils.isBlank((String)this.step.getText())) {
            throw new IllegalArgumentException("Need to specify either file or text to readManifest, can't do both.");
        }
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            return this.parseFile(this.step.getFile());
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            return this.parseText(this.step.getText());
        }
        throw new IllegalStateException("A somewhat strange combination appeared.");
    }

    private SimpleManifest parseText(String text) throws IOException {
        Manifest manifest = new Manifest(new ByteArrayInputStream(text.getBytes("UTF-8")));
        return new SimpleManifest(manifest);
    }

    private SimpleManifest parseFile(String file) throws IOException, InterruptedException {
        FilePath path = this.ws.child(file);
        if (!path.exists()) {
            throw new FileNotFoundException(path.getRemote() + " does not exist.");
        }
        if (path.isDirectory()) {
            throw new FileNotFoundException(path.getRemote() + " is a directory.");
        }
        String lcName = path.getName().toLowerCase();
        if (lcName.endsWith(".jar") || lcName.endsWith(".war") || lcName.endsWith(".ear")) {
            Map mf = (Map)path.act((FilePath.FileCallable)new UnZipStepExecution.UnZipFileCallable(this.listener, this.ws, "META-INF/MANIFEST.MF", true));
            String text = (String)mf.get("META-INF/MANIFEST.MF");
            if (StringUtils.isBlank((String)text)) {
                throw new FileNotFoundException(path.getRemote() + " does not seem to contain a manifest.");
            }
            return this.parseText(text);
        }
        Manifest manifest = new Manifest(path.read());
        return new SimpleManifest(manifest);
    }
}

