/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.zip;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.UnZipStep;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class UnZipStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Object> {
    private static final long serialVersionUID = 1L;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FilePath ws;
    @Inject
    private transient UnZipStep step;

    protected Object run() throws Exception {
        if (this.step.isTest()) {
            return this.test();
        }
        FilePath source = this.ws.child(this.step.getZipFile());
        if (!source.exists()) {
            throw new IOException(source.getRemote() + " does not exist.");
        }
        if (source.isDirectory()) {
            throw new IOException(source.getRemote() + " is a directory.");
        }
        FilePath destination = this.ws;
        if (!StringUtils.isBlank((String)this.step.getDir())) {
            destination = this.ws.child(this.step.getDir());
        }
        return source.act((FilePath.FileCallable)new UnZipFileCallable(this.listener, destination, this.step.getGlob(), this.step.isRead()));
    }

    private Boolean test() throws IOException, InterruptedException {
        FilePath source = this.ws.child(this.step.getZipFile());
        if (!source.exists()) {
            this.listener.error(source.getRemote() + " does not exist.");
            return false;
        }
        if (source.isDirectory()) {
            this.listener.error(source.getRemote() + " is a directory.");
            return false;
        }
        return (Boolean)source.act((FilePath.FileCallable)new TestZipFileCallable(this.listener));
    }

    static class TestZipFileCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private TaskListener listener;

        public TestZipFileCallable(TaskListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            PrintStream logger = this.listener.getLogger();
            try (ZipFile zip = null;){
                zip = new ZipFile(f);
                logger.print("Checking ");
                logger.print(zip.size());
                logger.print(" zipped entries in ");
                logger.println(f.getAbsolutePath());
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    zip.getInputStream(entry);
                }
                Boolean bl = true;
                return bl;
            }
        }
    }

    public static class UnZipFileCallable
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private final TaskListener listener;
        private final FilePath destination;
        private final String glob;
        private final boolean read;

        public UnZipFileCallable(TaskListener listener, FilePath destination, String glob, boolean read) {
            this.listener = listener;
            this.destination = destination;
            this.glob = glob;
            this.read = read;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> invoke(File zipFile, VirtualChannel channel) throws IOException, InterruptedException {
            if (!this.read) {
                this.destination.mkdirs();
            }
            PrintStream logger = this.listener.getLogger();
            ZipFile zip = null;
            boolean doGlob = !StringUtils.isBlank((String)this.glob);
            TreeMap<String, String> strMap = new TreeMap<String, String>();
            try {
                TreeMap<String, String> treeMap;
                logger.println("Extracting from " + zipFile.getAbsolutePath());
                zip = new ZipFile(zipFile);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (doGlob && !this.matches(entry.getName(), this.glob)) continue;
                    FilePath f = this.destination.child(entry.getName());
                    if (entry.isDirectory()) {
                        if (this.read) continue;
                        f.mkdirs();
                        continue;
                    }
                    if (!this.read) {
                        logger.print("Extracting: ");
                        logger.print(entry.getName());
                        logger.print(" -> ");
                        logger.println(f.getRemote());
                        IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)f.write());
                        continue;
                    }
                    logger.print("Reading: ");
                    logger.println(entry.getName());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), Charset.defaultCharset()));
                    Throwable throwable = null;
                    try {
                        String line = reader.readLine();
                        StringBuilder str = new StringBuilder();
                        while (line != null) {
                            if (str.length() >= 0) {
                                str.append('\n');
                            }
                            str.append(line);
                            line = reader.readLine();
                        }
                        strMap.put(entry.getName(), str.toString().trim());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                if (this.read) {
                    treeMap = strMap;
                    return treeMap;
                }
                treeMap = null;
                return treeMap;
            }
            finally {
                if (zip != null) {
                    zip.close();
                }
            }
        }

        boolean matches(String path, String glob) {
            String safeGlob = glob.replace('/', File.separatorChar);
            String safePath = path.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safeGlob, (String)safePath);
        }
    }
}

