/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.db;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.sql.DataSource;
import jenkins.model.Jenkins;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jenkinsci.plugins.pipeline.maven.db.AbstractPipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.db.Messages;

@Extension
public class PipelineMavenPluginH2Dao
extends AbstractPipelineMavenPluginDao {
    public PipelineMavenPluginH2Dao() {
    }

    public PipelineMavenPluginH2Dao(@NonNull DataSource ds) {
        super(ds);
    }

    @Override
    protected boolean acceptNoCredentials() {
        return true;
    }

    public String getDescription() {
        return Messages.dao_h2_description();
    }

    public PipelineMavenPluginH2Dao(@NonNull File rootDir) {
        this((DataSource)JdbcConnectionPool.create((String)("jdbc:h2:file:" + new File(rootDir, "jenkins-jobs").getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1;QUERY_CACHE_SIZE=25;JMX=TRUE"), (String)"sa", (String)"sa"));
    }

    @Override
    protected void registerJdbcDriver() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("H2 driver 'org.h2.Driver' not found. Please install the 'H2 Database Plugin' to install the H2 driver");
        }
    }

    @Override
    public String getJdbcScheme() {
        return "h2";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnoughProductionGradeForTheWorkload() {
        try (Connection cnn = this.getDataSource().getConnection();){
            int count;
            ResultSet rst;
            try (Statement stmt = cnn.createStatement();){
                rst = stmt.executeQuery("select count(*) from MAVEN_DEPENDENCY");
                try {
                    rst.next();
                    count = rst.getInt(1);
                    if (count > 100) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (rst != null) {
                        rst.close();
                    }
                }
            }
            stmt = cnn.createStatement();
            try {
                rst = stmt.executeQuery("select count(*) from GENERATED_MAVEN_ARTIFACT");
                try {
                    rst.next();
                    count = rst.getInt(1);
                    if (count > 100) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (rst != null) {
                        rst.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.INFO, "Exception counting rows", e);
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        block26: {
            this.LOGGER.log(Level.INFO, "Termination of the DAO Requested");
            boolean requireShutdown = false;
            try (Connection conn = this.getDataSource().getConnection();){
                String url = conn.getMetaData().getURL();
                requireShutdown = url.startsWith("jdbc:h2:file:");
            }
            catch (SQLException e) {
                this.LOGGER.log(Level.WARNING, "Failed to determin if the DB needs to be shutdown.", e);
            }
            if (requireShutdown) {
                this.LOGGER.log(Level.FINE, "Termination of the DAO Requested and shutdown is required");
                try (Connection con = this.getDataSource().getConnection();
                     Statement stmt = con.createStatement();){
                    stmt.execute("SHUTDOWN");
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 90121) {
                        this.LOGGER.log(Level.FINE, "Failed to close the database as it is already closed", e);
                        break block26;
                    }
                    this.LOGGER.log(Level.WARNING, "Failed to cleanly close the database", e);
                }
            } else {
                this.LOGGER.log(Level.FINE, "Termination of the DAO Requested not required, as requireShutdown is false");
            }
        }
        super.close();
    }

    public String getDefaultJdbcUrl() {
        boolean created;
        File databaseRootDir = new File(Jenkins.get().getRootDir(), "jenkins-jobs");
        if (!databaseRootDir.exists() && !(created = databaseRootDir.mkdirs())) {
            throw new IllegalStateException("Failure to create database root dir " + databaseRootDir);
        }
        return "jdbc:h2:file:" + new File(databaseRootDir, "jenkins-jobs").getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1;QUERY_CACHE_SIZE=25;JMX=TRUE";
    }
}

