/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import com.google.inject.Inject;
import hudson.FilePath;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Failure;
import hudson.model.FileParameterValue;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.ApproverAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.jenkinsci.plugins.workflow.support.steps.input.Outcome;
import org.jenkinsci.plugins.workflow.support.steps.input.POSTHyperlinkNote;
import org.jenkinsci.plugins.workflow.support.steps.input.Rejection;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class InputStepExecution
extends AbstractStepExecutionImpl
implements ModelObject {
    @StepContextParameter
    private transient Run run;
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FlowNode node;
    private Outcome outcome;
    @Inject(optional=true)
    InputStep input;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        this.getPauseAction().add(this);
        this.node.addAction((Action)new PauseAction("Input"));
        String baseUrl = '/' + this.run.getUrl() + this.getPauseAction().getUrlName() + '/';
        if (this.input.getParameters().isEmpty()) {
            String thisUrl = baseUrl + Util.rawEncode((String)this.getId()) + '/';
            this.listener.getLogger().printf("%s%n%s or %s%n", this.input.getMessage(), POSTHyperlinkNote.encodeTo((String)(thisUrl + "proceedEmpty"), (String)this.input.getOk()), POSTHyperlinkNote.encodeTo((String)(thisUrl + "abort"), (String)"Abort"));
        } else {
            this.listener.getLogger().println(HyperlinkNote.encodeTo((String)baseUrl, (String)"Input requested"));
        }
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        this.doAbort();
    }

    public String getId() {
        return this.input.getId();
    }

    public InputStep getInput() {
        return this.input;
    }

    public Run getRun() {
        return this.run;
    }

    public boolean isSettled() {
        return this.outcome != null;
    }

    private InputAction getPauseAction() {
        InputAction a = (InputAction)this.run.getAction(InputAction.class);
        if (a == null) {
            a = new InputAction();
            this.run.addAction((Action)a);
        }
        return a;
    }

    public String getDisplayName() {
        String message = this.getInput().getMessage();
        if (message.length() < 32) {
            return message;
        }
        return message.substring(0, 32) + "...";
    }

    @RequirePOST
    public HttpResponse doSubmit(StaplerRequest request) throws IOException, ServletException, InterruptedException {
        if (request.getParameter("proceed") != null) {
            this.doProceed(request);
        } else {
            this.doAbort();
        }
        return HttpResponses.redirectTo((String)"../../console");
    }

    @RequirePOST
    public HttpResponse doProceed(StaplerRequest request) throws IOException, ServletException, InterruptedException {
        this.preSubmissionCheck();
        Object v = this.parseValue(request);
        return this.proceed(v);
    }

    public HttpResponse proceed(Object v) throws IOException {
        User user = User.current();
        if (user != null) {
            this.run.addAction((Action)new ApproverAction(user.getId()));
            this.listener.getLogger().println("Approved by " + ModelHyperlinkNote.encodeTo((User)user));
        }
        this.outcome = new Outcome(v, null);
        this.getContext().onSuccess(v);
        this.postSettlement();
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doProceedEmpty() throws IOException {
        this.preSubmissionCheck();
        return this.proceed(null);
    }

    @RequirePOST
    public HttpResponse doAbort() throws IOException, ServletException {
        this.preAbortCheck();
        FlowInterruptedException e = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[]{new Rejection(User.current())});
        this.outcome = new Outcome(null, (Throwable)e);
        this.getContext().onFailure((Throwable)e);
        this.postSettlement();
        return HttpResponses.ok();
    }

    private void preAbortCheck() {
        if (this.isSettled()) {
            throw new Failure("This input has been already given");
        }
        if (!this.canCancel() && !this.canSubmit()) {
            throw new Failure("You need to be '" + this.input.getSubmitter() + "' (or have Job CANCEL permissions) to cancel this.");
        }
    }

    private void preSubmissionCheck() {
        if (this.isSettled()) {
            throw new Failure("This input has been already given");
        }
        if (!this.canSubmit()) {
            throw new Failure("You need to be " + this.input.getSubmitter() + " to submit this");
        }
    }

    private void postSettlement() throws IOException {
        try {
            this.getPauseAction().remove(this);
            this.run.save();
        }
        finally {
            if (this.node != null) {
                PauseAction.endCurrentPause((FlowNode)this.node);
            } else assert (false) : "cannot set pause end time for " + this.getId() + " in " + this.run;
        }
    }

    private boolean canCancel() {
        return this.getRun().getParent().hasPermission(Job.CANCEL);
    }

    private boolean canSubmit() {
        Authentication a = Jenkins.getAuthentication();
        return this.canSettle(a);
    }

    private boolean canSettle(Authentication a) {
        String submitter = this.input.getSubmitter();
        if (submitter == null || a.getName().equals(submitter)) {
            return true;
        }
        for (GrantedAuthority ga : a.getAuthorities()) {
            if (!ga.getAuthority().equals(submitter)) continue;
            return true;
        }
        return false;
    }

    private Object parseValue(StaplerRequest request) throws ServletException, IOException, InterruptedException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        List<ParameterDefinition> defs = this.input.getParameters();
        Object params = request.getSubmittedForm().get("parameter");
        if (params != null) {
            for (Object o : JSONArray.fromObject((Object)params)) {
                JSONObject jo = (JSONObject)o;
                String name = jo.getString("name");
                ParameterDefinition d = null;
                for (ParameterDefinition def : defs) {
                    if (!def.getName().equals(name)) continue;
                    d = def;
                }
                if (d == null) {
                    throw new IllegalArgumentException("No such parameter definition: " + name);
                }
                ParameterValue v = d.createValue(request, jo);
                if (v == null) continue;
                mapResult.put(name, this.convert(name, v));
            }
        }
        switch (mapResult.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return mapResult.values().iterator().next();
            }
        }
        return mapResult;
    }

    private Object convert(String name, ParameterValue v) throws IOException, InterruptedException {
        if (v instanceof FileParameterValue) {
            FileParameterValue fv = (FileParameterValue)v;
            FilePath fp = new FilePath(this.run.getRootDir()).child(name);
            fp.copyFrom(fv.getFile());
            return fp;
        }
        return v.getValue();
    }
}

