/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.SAXException;

public class JMeterCsvParser
extends AbstractParser {
    public char delimiter;
    public int timestampIdx = -1;
    public int elapsedIdx = -1;
    public int responseCodeIdx = -1;
    public int successIdx = -1;
    public int urlIdx = -1;

    @DataBoundConstructor
    public JMeterCsvParser(String glob, String percentiles) {
        super(glob, percentiles);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        this.clearDateFormat();
        PerformanceReport report = new PerformanceReport(this.percentiles);
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setReportFileName(reportFile.getName());
        String[] header = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(reportFile));){
            String line = reader.readLine();
            if (line != null) {
                header = this.readCSVHeader(line);
            }
        }
        try (FileReader fileReader = new FileReader(reportFile);){
            this.parseCSV(fileReader, header, report);
        }
        return report;
    }

    protected void parseCSV(Reader in, String[] header, PerformanceReport report) throws IOException {
        CSVFormat csvFormat = CSVFormat.newFormat((char)this.delimiter).withHeader(header).withQuote('\"').withSkipHeaderRecord();
        CSVParser records = csvFormat.parse(in);
        for (CSVRecord record : records) {
            HttpSample sample = this.getSample(record);
            try {
                report.addSample(sample);
            }
            catch (SAXException e) {
                throw new RuntimeException("Error parsing file '" + report.getReportFileName() + "': Unable to add sample for CSVRecord " + record, e);
            }
        }
    }

    protected String[] readCSVHeader(String line) throws Exception {
        this.delimiter = JMeterCsvParser.lookingForDelimiter(line);
        String[] header = line.split(String.valueOf(this.delimiter));
        for (int i = 0; i < header.length; ++i) {
            String field = header[i];
            if ("timestamp".equalsIgnoreCase(field)) {
                this.timestampIdx = i;
                continue;
            }
            if ("elapsed".equalsIgnoreCase(field)) {
                this.elapsedIdx = i;
                continue;
            }
            if ("responseCode".equalsIgnoreCase(field)) {
                this.responseCodeIdx = i;
                continue;
            }
            if ("success".equalsIgnoreCase(field)) {
                this.successIdx = i;
                continue;
            }
            if ("URL".equalsIgnoreCase(field) && this.urlIdx < 0) {
                this.urlIdx = i;
                continue;
            }
            if (!"label".equalsIgnoreCase(field) || this.urlIdx >= 0) continue;
            this.urlIdx = i;
        }
        if (this.timestampIdx < 0 || this.elapsedIdx < 0 || this.responseCodeIdx < 0 || this.successIdx < 0 || this.urlIdx < 0) {
            throw new Exception("Missing required column");
        }
        return header;
    }

    protected static char lookingForDelimiter(String line) throws Exception {
        for (char ch : line.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return ch;
        }
        throw new Exception("Cannot find delimiter in header " + line);
    }

    private HttpSample getSample(CSVRecord record) {
        HttpSample sample = new HttpSample();
        sample.setDate(this.parseTimestamp(record.get(this.timestampIdx)));
        sample.setDuration(Long.valueOf(record.get(this.elapsedIdx)));
        sample.setHttpCode(record.get(this.responseCodeIdx));
        sample.setSuccessful(Boolean.valueOf(record.get(this.successIdx)));
        sample.setUri(record.get(this.urlIdx));
        return sample;
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeterCSV";
        }
    }
}

