/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.File;
import java.util.Date;
import java.util.Scanner;
import org.kohsuke.stapler.DataBoundConstructor;

public class WrkSummarizerParser
extends AbstractParser {
    @DataBoundConstructor
    public WrkSummarizerParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.wrk";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        r = new PerformanceReport();
        r.setExcludeResponseTime(this.excludeResponseTime);
        r.setReportFileName(reportFile.getName());
        s = null;
        try {
            s = new Scanner(reportFile);
            sample = new HttpSample();
lbl8:
            // 10 sources

            block14: while (s.hasNextLine()) {
                scanner = null;
                try {
                    line = s.nextLine();
                    scanner = new Scanner(line.toLowerCase().replaceAll("(\\d)s|ms|%|mb|kb(\\b)", "$1$2"));
                    firstToken = scanner.next();
                    secondToken = scanner.next();
                    switch (1.$SwitchMap$hudson$plugins$performance$parsers$WrkSummarizerParser$LineType[this.determineLineType(firstToken, secondToken).ordinal()]) {
                        case 1: {
                            scanner.next();
                            scanner.next();
                            uri = scanner.next();
                            sample.setUri(uri);
                            ** break;
                        }
                        case 2: {
                            latencyScanner = new Scanner(line.toLowerCase());
                            latencyScanner.next();
                            latencyAvg = this.getTime(latencyScanner.next(), TimeUnit.MILLISECOND);
                            latencyScanner.next();
                            latencyMax = this.getTime(latencyScanner.next(), TimeUnit.MILLISECOND);
                            sample.setDuration(latencyAvg);
                            sample.setSummarizerMax(latencyMax);
                            ** break;
                        }
                        case 3: {
                            ** break;
                        }
                        case 4: {
                            totalReq = Long.parseLong(firstToken);
                            summaryScanner = new Scanner(line.toLowerCase());
                            summaryScanner.next();
                            summaryScanner.next();
                            summaryScanner.next();
                            sample.setSummarizer(true);
                            sample.setSummarizerSamples(totalReq);
                            summaryScanner.close();
                            ** break;
                        }
                        case 5: {
                            scanner.next();
                            scanner.next();
                            numErrors = scanner.nextInt();
                            sample.setSummarizerErrors(numErrors);
                            ** break;
                        }
                        case 6: 
                        case 7: {
                            ** break;
                        }
                        ** default:
lbl61:
                        // 1 sources

                        continue block14;
                    }
                }
                finally {
                    if (scanner == null) continue;
                    scanner.close();
                }
            }
            sample.setSuccessful(true);
            sample.setDate(new Date());
            r.addSample(sample);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        return r;
    }

    public long getTime(String timeString, TimeUnit tu) {
        double factor = 0.0;
        timeString = timeString.trim().replaceAll("[^\\d\\.smh]", "");
        String timeUnitString = timeString.replaceAll("[\\d\\.]", "");
        String timeValueString = timeString.replaceAll("[smh]", "");
        if (timeUnitString.equals("ms")) {
            factor = 1.0;
        } else if (timeUnitString.equals("s")) {
            factor = 1000.0;
        } else if (timeUnitString.equals("m")) {
            factor = 60000.0;
        } else if (timeUnitString.equals("h")) {
            factor = 3600000.0;
        }
        double timeValue = Double.parseDouble(timeValueString);
        double timeInMilliSeconds = timeValue * factor;
        double timeInReturnFormat = timeInMilliSeconds / (double)tu.getFactor();
        return (int)Math.floor(timeInReturnFormat);
    }

    /*
     * Loose catch block
     */
    public LineType determineLineType(String t1, String t2) {
        block14: {
            if (t1.equals("running")) {
                return LineType.RUNNING;
            }
            if (t1.equals("thread")) {
                return LineType.OUTPUT_HEADER;
            }
            if (t1.equals("latency")) {
                if (t2.equals("distribution")) {
                    return LineType.LATENCY_DIST_BUCKET_HEADER;
                }
                return LineType.LATENCY_DIST;
            }
            if (t1.equals("req/sec")) {
                return LineType.REQ_SEC_DIST;
            }
            if (t1.equals("requests/sec:")) {
                return LineType.REQ_SEC;
            }
            if (t1.equals("transfer/sec:")) {
                return LineType.TRANSFER_SEC;
            }
            if (t1.equals("non-2xx")) {
                return LineType.ERROR_COUNT;
            }
            Long.parseLong(t1);
            if (t2.equals("threads")) {
                return LineType.THREAD_CONN_COUNT;
            }
            if (!t2.equals("requests")) break block14;
            return LineType.SUMMARY;
            {
                catch (NumberFormatException e) {
                    return LineType.UNKNOWN;
                }
            }
        }
        try {
            Float.parseFloat(t2);
            return LineType.LATENCY_DIST_BUCKET;
        }
        catch (NumberFormatException e) {
            return LineType.UNKNOWN;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "wrk";
        }
    }

    public static enum TimeUnit {
        MILLISECOND(1),
        SECOND(1000),
        MINUTE(60000),
        HOUR(3600000);

        private final int factor;

        private TimeUnit(int factor) {
            this.factor = factor;
        }

        public int getFactor() {
            return this.factor;
        }
    }

    private static enum LineType {
        RUNNING,
        THREAD_CONN_COUNT,
        OUTPUT_HEADER,
        LATENCY_DIST,
        LATENCY_DIST_BUCKET_HEADER,
        LATENCY_DIST_BUCKET,
        REQ_SEC_DIST,
        SUMMARY,
        REQ_SEC,
        TRANSFER_SEC,
        ERROR_COUNT,
        UNKNOWN;

    }
}

