/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.File;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public class JmeterSummarizerParser
extends AbstractParser {
    @DataBoundConstructor
    public JmeterSummarizerParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        this.clearDateFormat();
        PerformanceReport report = new PerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setReportFileName(reportFile.getName());
        try (Scanner fileScanner = null;){
            fileScanner = new Scanner(reportFile);
            String lastEqualsLine = null;
            while (fileScanner.hasNextLine()) {
                String line = fileScanner.nextLine();
                if (!line.contains("=") || !line.contains("Summariser:")) continue;
                lastEqualsLine = line;
            }
            long reportSamples = Long.MIN_VALUE;
            long reportAvg = Long.MIN_VALUE;
            long reportMin = Long.MAX_VALUE;
            long reportMax = Long.MIN_VALUE;
            String reportErrorPercent = "";
            Scanner lineScanner = null;
            if (lastEqualsLine != null) {
                try {
                    lineScanner = new Scanner(lastEqualsLine);
                    Pattern delimiter = lineScanner.delimiter();
                    lineScanner.useDelimiter("INFO");
                    HttpSample sample = new HttpSample();
                    String dateString = lineScanner.next();
                    sample.setDate(this.parseTimestamp(dateString));
                    lineScanner.findInLine("Summariser:");
                    lineScanner.useDelimiter("\\=");
                    String key = lineScanner.next().trim();
                    lineScanner.useDelimiter(delimiter);
                    lineScanner.next();
                    reportSamples = lineScanner.nextLong();
                    sample.setSummarizerSamples(reportSamples);
                    sample.setSummarizer(true);
                    lineScanner.findInLine("Avg:");
                    sample.setDuration(lineScanner.nextLong());
                    reportAvg = sample.getDuration();
                    sample.setSuccessful(true);
                    lineScanner.findInLine("Min:");
                    long sampleMin = lineScanner.nextLong();
                    sample.setSummarizerMin(sampleMin);
                    reportMin = Math.min(reportMin, sampleMin);
                    lineScanner.findInLine("Max:");
                    long sampleMax = lineScanner.nextLong();
                    sample.setSummarizerMax(sampleMax);
                    reportMax = Math.max(reportMax, sampleMax);
                    lineScanner.findInLine("Err:");
                    lineScanner.findInLine("\\(");
                    lineScanner.useDelimiter("%");
                    reportErrorPercent = lineScanner.next();
                    sample.setSummarizerErrors(Float.parseFloat(reportErrorPercent));
                    sample.setUri(key);
                    report.addSample(sample);
                }
                finally {
                    if (lineScanner != null) {
                        lineScanner.close();
                    }
                }
            }
            report.setSummarizerSize(reportSamples);
            report.setSummarizerAvg(reportAvg);
            report.setSummarizerMin(reportMin);
            report.setSummarizerMax(reportMax);
            report.setSummarizerErrors(reportErrorPercent);
            PerformanceReport performanceReport = report;
            return performanceReport;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JmeterSummarizer";
        }
    }
}

