/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JMeterParser
extends AbstractParser {
    public JMeterParser(String glob, String percentiles) {
        super(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public JMeterParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.jtl";
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        boolean isXml = JMeterParser.isXmlFile(reportFile);
        if (isXml) {
            return this.parseXml(reportFile);
        }
        return this.parseCsv(reportFile);
    }

    /*
     * Exception decompiling
     */
    public static boolean isXmlFile(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    PerformanceReport parseXml(File reportFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        final PerformanceReport report = this.createPerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setShowTrendGraphs(this.showTrendGraphs);
        report.setReportFileName(reportFile.getName());
        factory.newSAXParser().parse(reportFile, new DefaultHandler(){
            HttpSample currentSample;
            int counter = 0;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!"httpSample".equalsIgnoreCase(qName) && !"sample".equalsIgnoreCase(qName)) {
                    return;
                }
                HttpSample sample = new HttpSample();
                String dateValue = attributes.getValue("ts") != null ? attributes.getValue("ts") : attributes.getValue("timeStamp");
                sample.setDate(new Date(Long.valueOf(dateValue)));
                String durationValue = attributes.getValue("t") != null ? attributes.getValue("t") : attributes.getValue("time");
                sample.setDuration(Long.valueOf(durationValue));
                String successfulValue = attributes.getValue("s") != null ? attributes.getValue("s") : attributes.getValue("success");
                sample.setSuccessful(Boolean.parseBoolean(successfulValue));
                String uriValue = attributes.getValue("lb") != null ? attributes.getValue("lb") : attributes.getValue("label");
                sample.setUri(uriValue);
                String httpCodeValue = attributes.getValue("rc") != null && attributes.getValue("rc").length() <= 3 ? attributes.getValue("rc") : "0";
                sample.setHttpCode(httpCodeValue);
                String sizeInKbValue = attributes.getValue("by") != null ? attributes.getValue("by") : "0";
                sample.setSizeInKb(Double.valueOf(sizeInKbValue) / 1024.0);
                if (this.counter == 0) {
                    this.currentSample = sample;
                }
                ++this.counter;
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
                    if (this.counter == 1) {
                        report.addSample(this.currentSample);
                    }
                    --this.counter;
                }
            }
        });
        return report;
    }

    PerformanceReport parseCsv(File reportFile) throws Exception {
        JMeterCsvParser delegate = new JMeterCsvParser(this.glob, this.percentiles, this.filterRegex);
        return delegate.parse(reportFile);
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeter";
        }
    }
}

