/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.plugins.performance.parsers.IagoParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.JUnitParser;
import hudson.plugins.performance.parsers.JmeterSummarizerParser;
import hudson.plugins.performance.parsers.TaurusParser;
import hudson.plugins.performance.parsers.WrkSummarizerParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserDetector {
    public static String detect(String reportPath) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(new File(reportPath)));
        String line = reader.readLine();
        if (line == null) {
            throw new IllegalArgumentException("File " + reportPath + " is empty");
        }
        if (line.startsWith("<?xml")) {
            return ParserDetector.detectXMLFileType(reader, null);
        }
        if (ParserDetector.isIagoFileType(line)) {
            return IagoParser.class.getSimpleName();
        }
        if (ParserDetector.isWRKFileType(line)) {
            return WrkSummarizerParser.class.getSimpleName();
        }
        if (ParserDetector.isJMeterCSVFileType(line)) {
            return JMeterCsvParser.class.getSimpleName();
        }
        if (ParserDetector.isJMeterSummarizerFileType(line, reader)) {
            return JmeterSummarizerParser.class.getSimpleName();
        }
        try {
            return ParserDetector.detectXMLFileType(reader, line);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Can not detect file type: " + reportPath, ex);
        }
    }

    private static boolean isIagoFileType(String line) {
        String patternString = "INF \\[.*\\] stats:.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        return matcher.matches();
    }

    private static boolean isWRKFileType(String line) {
        String patternString = "Running .*s test @.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        return matcher.matches();
    }

    private static boolean isJMeterCSVFileType(String header) {
        String line = header.toLowerCase();
        return line.contains("timestamp") && line.contains("elapsed") && (line.contains("url") || line.contains("label"));
    }

    private static boolean isJMeterSummarizerFileType(String firstLine, BufferedReader reader) throws IOException {
        String line = firstLine;
        String pattern = "jmeter.reporters.Summariser: Generate Summary Results";
        if (line.contains(pattern)) {
            return true;
        }
        line = reader.readLine();
        while (line != null) {
            if (line.contains(pattern)) {
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }

    private static String detectXMLFileType(BufferedReader reader, String lineToAnalyze) throws IOException {
        String line;
        String string = line = lineToAnalyze != null ? lineToAnalyze : reader.readLine();
        if (line == null) {
            throw new IllegalArgumentException("File contains only xml header");
        }
        if (line.contains("<testResults")) {
            return JMeterParser.class.getSimpleName();
        }
        if (line.contains("<testsuite")) {
            return JUnitParser.class.getSimpleName();
        }
        if (line.contains("<FinalStatus>")) {
            return TaurusParser.class.getSimpleName();
        }
        throw new IllegalArgumentException("Unknown xml file format");
    }
}

