/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.tools.SafeMaths;
import java.io.File;
import java.util.Date;
import java.util.Scanner;
import org.kohsuke.stapler.DataBoundConstructor;

public class WrkSummarizerParser
extends AbstractParser {
    public WrkSummarizerParser(String glob, String percentiles) {
        super(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public WrkSummarizerParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.wrk";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        r = this.createPerformanceReport();
        r.setExcludeResponseTime(this.excludeResponseTime);
        r.setReportFileName(reportFile.getName());
        s = null;
        try {
            s = new Scanner(reportFile);
            sample = new HttpSample();
lbl8:
            // 10 sources

            block14: while (s.hasNextLine()) {
                scanner = null;
                try {
                    line = s.nextLine();
                    scanner = new Scanner(line.toLowerCase().replaceAll("(\\d)s|ms|%|mb|kb(\\b)", "$1$2"));
                    firstToken = scanner.next();
                    secondToken = scanner.next();
                    switch (1.$SwitchMap$hudson$plugins$performance$parsers$WrkSummarizerParser$LineType[this.determineLineType(firstToken, secondToken).ordinal()]) {
                        case 1: {
                            scanner.next();
                            scanner.next();
                            uri = scanner.next();
                            sample.setUri(uri);
                            ** break;
                        }
                        case 2: {
                            latencyScanner = new Scanner(line.toLowerCase());
                            latencyScanner.next();
                            latencyAvg = this.getTime(latencyScanner.next(), TimeUnit.MILLISECOND);
                            latencyScanner.next();
                            latencyMax = this.getTime(latencyScanner.next(), TimeUnit.MILLISECOND);
                            sample.setDuration(latencyAvg);
                            sample.setSummarizerMax(latencyMax);
                            ** break;
                        }
                        case 3: {
                            ** break;
                        }
                        case 4: {
                            totalReq = Long.parseLong(firstToken);
                            summaryScanner = new Scanner(line.toLowerCase());
                            summaryScanner.next();
                            summaryScanner.next();
                            summaryScanner.next();
                            sample.setSummarizer(true);
                            sample.setSummarizerSamples(totalReq);
                            summaryScanner.close();
                            ** break;
                        }
                        case 5: {
                            scanner.next();
                            scanner.next();
                            numErrors = scanner.nextInt();
                            sample.setSummarizerErrors(numErrors);
                            ** break;
                        }
                        case 6: 
                        case 7: {
                            ** break;
                        }
                        ** default:
lbl61:
                        // 1 sources

                        continue block14;
                    }
                }
                finally {
                    if (scanner == null) continue;
                    scanner.close();
                }
            }
            sample.setSuccessful(true);
            sample.setDate(new Date());
            r.addSample(sample);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        return r;
    }

    public long getTime(String timeString, TimeUnit tu) {
        double factor = 0.0;
        timeString = timeString.trim().replaceAll("[^\\d\\.smh]", "");
        String timeUnitString = timeString.replaceAll("[\\d\\.]", "");
        String timeValueString = timeString.replaceAll("[smh]", "");
        if ("ms".equals(timeUnitString)) {
            factor = 1.0;
        } else if ("s".equals(timeUnitString)) {
            factor = 1000.0;
        } else if ("m".equals(timeUnitString)) {
            factor = 60000.0;
        } else if ("h".equals(timeUnitString)) {
            factor = 3600000.0;
        }
        double timeValue = Double.parseDouble(timeValueString);
        double timeInMilliSeconds = timeValue * factor;
        double timeInReturnFormat = SafeMaths.safeDivide(timeInMilliSeconds, tu.getFactor());
        return (int)Math.floor(timeInReturnFormat);
    }

    /*
     * Loose catch block
     */
    public LineType determineLineType(String t1, String t2) {
        block14: {
            if ("running".equals(t1)) {
                return LineType.RUNNING;
            }
            if ("thread".equals(t1)) {
                return LineType.OUTPUT_HEADER;
            }
            if ("latency".equals(t1)) {
                if ("distribution".equals(t2)) {
                    return LineType.LATENCY_DIST_BUCKET_HEADER;
                }
                return LineType.LATENCY_DIST;
            }
            if ("req/sec".equals(t1)) {
                return LineType.REQ_SEC_DIST;
            }
            if ("requests/sec:".equals(t1)) {
                return LineType.REQ_SEC;
            }
            if ("transfer/sec:".equals(t1)) {
                return LineType.TRANSFER_SEC;
            }
            if ("non-2xx".equals(t1)) {
                return LineType.ERROR_COUNT;
            }
            Long.parseLong(t1);
            if ("threads".equals(t2)) {
                return LineType.THREAD_CONN_COUNT;
            }
            if (!"requests".equals(t2)) break block14;
            return LineType.SUMMARY;
            {
                catch (NumberFormatException e) {
                    return LineType.UNKNOWN;
                }
            }
        }
        try {
            Float.parseFloat(t2);
            return LineType.LATENCY_DIST_BUCKET;
        }
        catch (NumberFormatException e) {
            return LineType.UNKNOWN;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "wrk";
        }
    }

    public static enum TimeUnit {
        MILLISECOND(1),
        SECOND(1000),
        MINUTE(60000),
        HOUR(3600000);

        private final int factor;

        private TimeUnit(int factor) {
            this.factor = factor;
        }

        public int getFactor() {
            return this.factor;
        }
    }

    private static enum LineType {
        RUNNING,
        THREAD_CONN_COUNT,
        OUTPUT_HEADER,
        LATENCY_DIST,
        LATENCY_DIST_BUCKET_HEADER,
        LATENCY_DIST_BUCKET,
        REQ_SEC_DIST,
        SUMMARY,
        REQ_SEC,
        TRANSFER_SEC,
        ERROR_COUNT,
        UNKNOWN;

    }
}

