/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.reports;

import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.performance.actions.PerformanceProjectAction;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.data.TaurusFinalStats;
import hudson.plugins.performance.reports.AbstractReport;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.tools.SafeMaths;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class UriReport
extends AbstractReport
implements Serializable,
ModelObject,
Comparable<UriReport> {
    private static final long serialVersionUID = -5269155428479638524L;
    public static final String END_PERFORMANCE_PARAMETER = ".endperformanceparameter";
    private final String staplerUri;
    private UriReport lastBuildUriReport;
    private final PerformanceReport performanceReport;
    private String uri;
    private int nbError = 0;
    private final List<Sample> samples = new ArrayList<Sample>();
    private transient List<Long> durationsIO = new ArrayList<Long>();
    private transient List<Long> durationsSortedBySize = new ArrayList<Long>();
    private transient boolean isSorted = false;
    private long totalDuration = 0L;
    private Set<String> httpCodes = new HashSet<String>();
    private long summarizerSize = 0L;
    private float summarizerErrors = 0.0f;
    private Date start = null;
    private Date end = null;
    private Long average;
    private Long perc0;
    private Long perc50;
    private Long perc90;
    private Long perc100;
    @Deprecated
    private Long throughput;
    private int samplesCount;
    protected String percentiles;

    public Object readResolve() {
        this.checkPercentileAndSet(0.0, this.perc0);
        this.checkPercentileAndSet(50.0, this.perc50);
        this.checkPercentileAndSet(90.0, this.perc90);
        this.checkPercentileAndSet(100.0, this.perc100);
        if (StringUtils.isBlank((String)this.percentiles)) {
            this.percentiles = "0,50,90,100";
        }
        return this;
    }

    public UriReport(PerformanceReport performanceReport, String staplerUri, String uri) {
        this.performanceReport = performanceReport;
        this.staplerUri = staplerUri;
        this.uri = uri;
        this.percentiles = performanceReport.percentiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpSample(HttpSample sample) {
        if (!sample.isSuccessful()) {
            ++this.nbError;
        }
        List<Sample> list = this.samples;
        synchronized (list) {
            if (this.samples.add(Sample.convertFromHttpSample(sample))) {
                this.isSorted = false;
                ++this.samplesCount;
            }
        }
        if (this.isIncludeResponseTime(sample)) {
            this.totalDuration += sample.getDuration();
        }
        this.httpCodes.add(sample.getHttpCode());
        this.summarizerSize += sample.getSummarizerSamples();
        this.summarizerErrors += sample.getSummarizerErrors();
        if (this.start == null || sample.getDate().before(this.start)) {
            this.start = sample.getDate();
        }
        Date finish = new Date(sample.getDate().getTime() + sample.getDuration());
        if (this.end == null || finish.after(this.end)) {
            this.end = finish;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromTaurusFinalStats(TaurusFinalStats report) {
        this.average = (long)report.getAverageResponseTime();
        this.perc0 = (long)report.getPerc0();
        this.perc50 = (long)report.getPerc50();
        this.perc90 = (long)report.getPerc90();
        this.perc100 = (long)report.getPerc100();
        this.percentilesValues.put(0.0, (long)report.getPerc0());
        this.percentilesValues.put(50.0, (long)report.getPerc50());
        this.percentilesValues.put(90.0, (long)report.getPerc90());
        this.percentilesValues.put(100.0, (long)report.getPerc100());
        this.calculateDiffPercentiles();
        this.isCalculatedPercentilesValues = true;
        this.summarizerSize = report.getBytes();
        this.summarizerErrors = report.getFail();
        this.nbError = report.getFail();
        List<Sample> list = this.samples;
        synchronized (list) {
            this.samplesCount = report.getSucc() + report.getFail();
        }
    }

    @Override
    public int compareTo(UriReport uriReport) {
        if (uriReport == this) {
            return 0;
        }
        return uriReport.getUri().compareTo(this.getUri());
    }

    @Override
    public int countErrors() {
        return this.nbError;
    }

    @Override
    public double errorPercent() {
        return (double)Math.round(SafeMaths.safeDivide(this.countErrors(), this.samplesCount()) * 100.0 * 1000.0) / 1000.0;
    }

    @Override
    public long getAverage() {
        if (this.average == null) {
            int samplesCount = this.samplesCount();
            this.average = samplesCount == 0 ? 0L : (long)SafeMaths.safeDivide(this.totalDuration, samplesCount);
        }
        return this.average;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDurationAt(double percentage) {
        if (percentage < 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException("Argument 'percentage' must be a value between 0 and 100 (inclusive)");
        }
        List<Sample> list = this.samples;
        synchronized (list) {
            List<Long> durations = this.getSortedDuration();
            if (durations.isEmpty()) {
                return 0L;
            }
            double percentInDecimals = percentage / 100.0;
            int indexToReturn = (int)((double)this.durationsSortedBySize.size() * percentInDecimals) - 1;
            if (indexToReturn < 0) {
                indexToReturn = 0;
            } else if (indexToReturn >= this.durationsSortedBySize.size()) {
                indexToReturn = this.durationsSortedBySize.size() - 1;
            }
            return durations.get(indexToReturn);
        }
    }

    @Override
    public void calculatePercentiles() {
        List<Double> percs = super.parsePercentiles(this.percentiles);
        for (Double perc : percs) {
            this.percentilesValues.put(perc, this.getDurationAt(perc));
        }
        this.isCalculatedPercentilesValues = true;
    }

    @Override
    public void calculateDiffPercentiles() {
        List<Double> percs = super.parsePercentiles(this.percentiles);
        for (Double perc : percs) {
            Long diff = 0L;
            if (this.lastBuildUriReport != null) {
                Long previousValue = this.lastBuildUriReport.getPercentilesValues().get(perc);
                Long currentValue = this.getPercentilesValues().get(perc);
                if (previousValue != null && currentValue != null) {
                    diff = currentValue - previousValue;
                }
            }
            this.percentilesDiffValues.put(perc, diff);
        }
    }

    @Override
    public long get90Line() {
        if (this.perc90 == null) {
            this.perc90 = this.getDurationAt(90.0);
        }
        return this.perc90;
    }

    @Override
    public String getHttpCode() {
        return StringUtils.join(this.httpCodes, (char)',');
    }

    @Override
    public long getMedian() {
        if (this.perc50 == null) {
            this.perc50 = this.getDurationAt(50.0);
        }
        return this.perc50;
    }

    public Run<?, ?> getBuild() {
        return this.performanceReport.getBuild();
    }

    public String getDisplayName() {
        return this.getUri();
    }

    public List<Sample> getHttpSampleList() {
        return this.samples;
    }

    public PerformanceReport getPerformanceReport() {
        return this.performanceReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Long> getSortedDuration() {
        List<Sample> list = this.samples;
        synchronized (list) {
            if (!this.isSorted || this.durationsSortedBySize == null || this.durationsSortedBySize.size() != this.samples.size()) {
                this.durationsSortedBySize = new ArrayList<Long>(this.samplesCount());
                for (Sample sample : this.samples) {
                    if (!this.isIncludeResponseTime(sample)) continue;
                    this.durationsSortedBySize.add(sample.duration);
                }
                Collections.sort(this.durationsSortedBySize);
                this.isSorted = true;
            }
            return this.durationsSortedBySize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getDurations() {
        List<Sample> list = this.samples;
        synchronized (list) {
            if (this.durationsIO == null || this.durationsIO.size() != this.samples.size()) {
                this.durationsIO = new ArrayList<Long>(this.samples.size());
                for (Sample sample : this.samples) {
                    if (!this.isIncludeResponseTime(sample)) continue;
                    this.durationsIO.add(sample.duration);
                }
            }
            return this.durationsIO;
        }
    }

    @Override
    public long getMax() {
        if (this.perc100 == null) {
            this.perc100 = this.getDurationAt(100.0);
        }
        return this.perc100;
    }

    @Override
    public long getMin() {
        if (this.perc0 == null) {
            this.perc0 = this.getDurationAt(0.0);
        }
        return this.perc0;
    }

    public String getStaplerUri() {
        return this.staplerUri;
    }

    public String getUri() {
        return this.uri;
    }

    public String getShortUri() {
        if (this.uri.length() > 130) {
            return this.uri.substring(0, 129);
        }
        return this.uri;
    }

    public boolean isFailed() {
        return this.countErrors() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int samplesCount() {
        List<Sample> list = this.samples;
        synchronized (list) {
            return this.samplesCount;
        }
    }

    public String encodeUriReport() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(120);
        sb.append(this.performanceReport.getReportFileName()).append(":").append(this.getStaplerUri()).append(END_PERFORMANCE_PARAMETER);
        return URLEncoder.encode(sb.toString(), "UTF-8");
    }

    public void addLastBuildUriReport(UriReport lastBuildUriReport) {
        this.lastBuildUriReport = lastBuildUriReport;
        this.calculateDiffPercentiles();
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildUriReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildUriReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildUriReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildUriReport.getMedian();
    }

    @Override
    public long get90LineDiff() {
        if (this.lastBuildUriReport == null) {
            return 0L;
        }
        return this.get90Line() - this.lastBuildUriReport.get90Line();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildUriReport == null) {
            return 0.0;
        }
        return (double)Math.round((this.errorPercent() - this.lastBuildUriReport.errorPercent()) * 1000.0) / 1000.0;
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        if (this.lastBuildUriReport == null) {
            return "";
        }
        if (this.lastBuildUriReport.getHttpCode().equals(this.getHttpCode())) {
            return "";
        }
        return this.lastBuildUriReport.getHttpCode();
    }

    @Override
    public int getSamplesCountDiff() {
        if (this.lastBuildUriReport == null) {
            return 0;
        }
        return this.samplesCount() - this.lastBuildUriReport.samplesCount();
    }

    public float getSummarizerErrors() {
        return this.summarizerErrors / (float)this.summarizerSize * 100.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSummarizerTrendGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        TimeSeries responseTimes = new TimeSeries((Comparable)((Object)"Response Time"), FixedMillisecond.class);
        List<Sample> list = this.samples;
        synchronized (list) {
            for (Sample sample : this.samples) {
                if (!this.isIncludeResponseTime(sample)) continue;
                responseTimes.addOrUpdate((RegularTimePeriod)new FixedMillisecond(sample.date), (double)sample.duration);
            }
        }
        TimeSeriesCollection resp = new TimeSeriesCollection();
        resp.addSeries(responseTimes);
        ArrayList<XYDataset> dataset = new ArrayList<XYDataset>();
        dataset.add((XYDataset)resp);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)PerformanceProjectAction.createSummarizerTrend(dataset, this.uri), (int)400, (int)200);
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    protected boolean isIncludeResponseTime(Sample sample) {
        return !sample.isFailed() || !this.excludeResponseTime || sample.isSummarizer();
    }

    @Deprecated
    public void setThroughput(Long throughput) {
        this.throughput = throughput;
    }

    @Deprecated
    public Long getThroughput() {
        return this.throughput;
    }

    public boolean hasSamples() {
        return !this.samples.isEmpty();
    }

    public static class Sample
    implements Serializable,
    Comparable<Sample> {
        private static final long serialVersionUID = 4458431861223813407L;
        protected final Date date;
        protected final long duration;
        protected final String httpCode;
        protected final boolean isSuccessful;
        protected final boolean isSummarizer;

        public Sample(Date date, long duration, String httpCode, boolean isSuccessful, boolean isSummarizer) {
            this.date = date;
            this.duration = duration;
            this.httpCode = httpCode;
            this.isSuccessful = isSuccessful;
            this.isSummarizer = isSummarizer;
        }

        public static Sample convertFromHttpSample(HttpSample httpSample) {
            return new Sample(httpSample.getDate(), httpSample.getDuration(), httpSample.getHttpCode(), httpSample.isSuccessful(), httpSample.isSummarizer());
        }

        public String getHttpCode() {
            return this.httpCode;
        }

        public Date getDate() {
            return this.date;
        }

        public long getDuration() {
            return this.duration;
        }

        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        public boolean isFailed() {
            return !this.isSuccessful();
        }

        public boolean isSummarizer() {
            return this.isSummarizer;
        }

        @Override
        public int compareTo(Sample other) {
            if (this == other) {
                return 0;
            }
            if (this.duration < other.duration) {
                return -1;
            }
            if (this.duration > other.duration) {
                return 1;
            }
            if (this.date == null || other.date == null) {
                return 0;
            }
            if (this.date.before(other.date)) {
                return -1;
            }
            if (this.date.after(other.date)) {
                return 1;
            }
            return 0;
        }
    }
}

