/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.TrendReportGraphs;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.actions.PerformanceProjectAction;
import hudson.plugins.performance.data.PerformanceReportPosition;
import hudson.plugins.performance.data.ReportValueSelector;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PerformanceReportMap
implements ModelObject {
    private transient PerformanceBuildAction buildAction;
    private Map<String, PerformanceReport> performanceReportMap = new LinkedHashMap<String, PerformanceReport>();
    private static final String PERFORMANCE_REPORTS_DIRECTORY = "performance-reports";
    private static final String PLUGIN_NAME = "performance";
    private static final String TRENDREPORT_LINK = "trendReport";
    private static Run<?, ?> currentBuild = null;

    public PerformanceReportMap(final PerformanceBuildAction buildAction, TaskListener listener) throws IOException {
        this.buildAction = buildAction;
        this.parseReports(this.getBuild(), listener, new PerformanceReportCollector(){

            @Override
            public void addAll(Collection<PerformanceReport> reports) {
                for (PerformanceReport r : reports) {
                    r.setBuildAction(buildAction);
                    PerformanceReportMap.this.performanceReportMap.put(r.getReportFileName(), r);
                }
            }
        }, null);
    }

    private void addAll(Collection<PerformanceReport> reports) {
        for (PerformanceReport r : reports) {
            r.setBuildAction(this.buildAction);
            this.performanceReportMap.put(r.getReportFileName(), r);
        }
    }

    public Run<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public List<PerformanceReport> getPerformanceListOrdered() {
        ArrayList<PerformanceReport> listPerformance = new ArrayList<PerformanceReport>(this.getPerformanceReportMap().values());
        Collections.sort(listPerformance);
        return listPerformance;
    }

    public Map<String, PerformanceReport> getPerformanceReportMap() {
        return this.performanceReportMap;
    }

    public PerformanceReport getPerformanceReport(String performanceReportName) {
        return this.performanceReportMap.get(performanceReportName);
    }

    public UriReport getUriReport(String uriReport) {
        if (uriReport != null) {
            String uriReportDecoded;
            try {
                uriReportDecoded = URLDecoder.decode(uriReport.replace(".endperformanceparameter", ""), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
            StringTokenizer st = new StringTokenizer(uriReportDecoded, ":");
            return this.getPerformanceReportMap().get(st.nextToken()).getUriReportMap().get(st.nextToken());
        }
        return null;
    }

    public String getUrlName() {
        return PLUGIN_NAME;
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setPerformanceReportMap(Map<String, PerformanceReport> performanceReportMap) {
        this.performanceReportMap = performanceReportMap;
    }

    public static String getPerformanceReportFileRelativePath(String parserDisplayName, String reportFileName) {
        return PerformanceReportMap.getRelativePath(parserDisplayName, reportFileName);
    }

    public static String getPerformanceReportDirRelativePath() {
        return PerformanceReportMap.getRelativePath(new String[0]);
    }

    private static String getRelativePath(String ... suffixes) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(PERFORMANCE_REPORTS_DIRECTORY);
        for (String suffix : suffixes) {
            sb.append(File.separator).append(suffix);
        }
        return sb.toString();
    }

    public boolean isFailed(String performanceReportName) {
        return this.getPerformanceReport(performanceReportName) == null;
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("performanceReportPosition");
        Run<?, ?> previousBuild = this.getBuild();
        Map<Run<?, ?>, Map<String, PerformanceReport>> buildReports = this.getBuildReports(parameter, previousBuild);
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        ReportValueSelector valueSelector = ReportValueSelector.get(this.getBuild().getParent());
        String keyLabel = this.getKeyLabel(valueSelector.getGraphType());
        for (Run<?, ?> currentBuild : buildReports.keySet()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
            PerformanceReport report = buildReports.get(currentBuild).get(parameter);
            dataSetBuilder.add((Number)valueSelector.getValue(report), (Comparable)((Object)keyLabel), (Comparable)label);
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createRespondingTimeChart(dataSetBuilder.build()), (int)400, (int)200);
    }

    protected JFreeChart createRespondingTimeChart(CategoryDataset dataset) {
        return PerformanceProjectAction.doCreateRespondingTimeChart(dataset);
    }

    private String getKeyLabel(String configType) {
        if (configType.equals("MRT")) {
            return Messages.ProjectAction_Median();
        }
        if (configType.equals("PRT")) {
            return Messages.ProjectAction_Line90();
        }
        return Messages.ProjectAction_Average();
    }

    private Map<Run<?, ?>, Map<String, PerformanceReport>> getBuildReports(String parameter, Run<?, ?> previousBuild) throws IOException {
        final LinkedHashMap buildReports = new LinkedHashMap();
        while (previousBuild != null) {
            final Run currentBuild = previousBuild;
            this.parseReports(currentBuild, TaskListener.NULL, new PerformanceReportCollector(){

                @Override
                public void addAll(Collection<PerformanceReport> parse) {
                    for (PerformanceReport performanceReport : parse) {
                        if (buildReports.get(currentBuild) == null) {
                            LinkedHashMap map = new LinkedHashMap();
                            buildReports.put(currentBuild, map);
                        }
                        ((Map)buildReports.get(currentBuild)).put(performanceReport.getReportFileName(), performanceReport);
                    }
                }
            }, parameter);
            previousBuild = previousBuild.getPreviousCompletedBuild();
        }
        return buildReports;
    }

    public void doSummarizerGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String parameter = request.getParameter("performanceReportPosition");
        Run<?, ?> previousBuild = this.getBuild();
        Map<Run<?, ?>, Map<String, PerformanceReport>> buildReports = this.getBuildReports(parameter, previousBuild);
        DataSetBuilder dataSetBuilderSummarizer = new DataSetBuilder();
        ReportValueSelector valueSelector = ReportValueSelector.get(this.getBuild().getParent());
        for (Run<?, ?> currentBuild : buildReports.keySet()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
            PerformanceReport report = buildReports.get(currentBuild).get(parameter);
            for (String key : report.getUriReportMap().keySet()) {
                long methodValue = valueSelector.getValue(report.getUriReportMap().get(key));
                dataSetBuilderSummarizer.add((Number)methodValue, (Comparable)label, (Comparable)((Object)key));
            }
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createSummarizerChart(dataSetBuilderSummarizer.build()), (int)400, (int)200);
    }

    protected JFreeChart createSummarizerChart(CategoryDataset dataset) {
        return PerformanceProjectAction.doCreateSummarizerChart(dataset, "ms", Messages.ProjectAction_RespondingTime());
    }

    protected void parseReports(Run<?, ?> build, TaskListener listener, PerformanceReportCollector collector, final String filename) throws IOException {
        File[] dirs;
        File repo = new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportDirRelativePath());
        File[] files = repo.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && !f.getName().endsWith(".serialized");
            }
        });
        if (files != null) {
            this.addAll(new JMeterParser("").parse(build, Arrays.asList(files), listener));
        }
        if ((dirs = repo.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            for (File dir : dirs) {
                PerformanceReportParser p = this.buildAction.getParserByDisplayName(dir.getName());
                if (p == null) continue;
                File[] listFiles = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (filename == null && !name.endsWith(".serialized")) {
                            return true;
                        }
                        return name.equals(filename);
                    }
                });
                try {
                    collector.addAll(p.parse(build, Arrays.asList(listFiles), listener));
                }
                catch (IOException ex) {
                    listener.getLogger().println("Unable to process directory '" + dir + "'.");
                    ex.printStackTrace(listener.getLogger());
                }
            }
        }
        this.addPreviousBuildReports();
    }

    private void addPreviousBuildReports() {
        if (currentBuild == null) {
            currentBuild = this.getBuild();
        } else if (currentBuild != this.getBuild()) {
            currentBuild = null;
            return;
        }
        Run previousBuild = this.getBuild().getPreviousCompletedBuild();
        if (previousBuild == null) {
            return;
        }
        PerformanceBuildAction previousPerformanceAction = (PerformanceBuildAction)previousBuild.getAction(PerformanceBuildAction.class);
        if (previousPerformanceAction == null) {
            return;
        }
        PerformanceReportMap previousPerformanceReportMap = previousPerformanceAction.getPerformanceReportMap();
        if (previousPerformanceReportMap == null) {
            return;
        }
        for (Map.Entry<String, PerformanceReport> item : this.getPerformanceReportMap().entrySet()) {
            PerformanceReport lastReport = previousPerformanceReportMap.getPerformanceReportMap().get(item.getKey());
            if (lastReport == null) continue;
            item.getValue().setLastBuildReport(lastReport);
        }
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerRequest response) {
        if (TRENDREPORT_LINK.equals(link)) {
            return this.createTrendReportGraphs(request);
        }
        return null;
    }

    public Object createTrendReportGraphs(StaplerRequest request) {
        String filename = this.getTrendReportFilename(request);
        PerformanceReport report = this.performanceReportMap.get(filename);
        Run<?, ?> build = this.getBuild();
        TrendReportGraphs trendReport = new TrendReportGraphs(build.getParent(), build, request, filename, report);
        return trendReport;
    }

    private String getTrendReportFilename(StaplerRequest request) {
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        return performanceReportPosition.getPerformanceReportPosition();
    }

    protected static interface PerformanceReportCollector {
        public void addAll(Collection<PerformanceReport> var1);
    }
}

