/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.constraints;

import hudson.AbortException;
import hudson.model.Run;
import hudson.plugins.performance.constraints.AbstractConstraint;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.ConstraintSettings;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class ConstraintChecker {
    private List<? extends Run<?, ?>> builds;
    private ConstraintSettings settings;

    public ConstraintChecker(ConstraintSettings settings, List<? extends Run<?, ?>> builds) {
        this.settings = settings;
        this.builds = builds;
    }

    public ArrayList<ConstraintEvaluation> checkAllConstraints(List<? extends AbstractConstraint> constraints) throws AbortException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ParseException {
        ArrayList<ConstraintEvaluation> result = new ArrayList<ConstraintEvaluation>();
        for (AbstractConstraint abstractConstraint : constraints) {
            abstractConstraint.setSettings(this.settings);
            try {
                result.add(abstractConstraint.evaluate(this.builds));
            }
            catch (Exception e) {
                this.settings.getListener().getLogger().println(e.getMessage());
            }
        }
        return result;
    }

    public ConstraintSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ConstraintSettings settings) {
        this.settings = settings;
    }

    public List<? extends Run<?, ?>> getBuilds() {
        return this.builds;
    }

    public void setBuilds(List<? extends Run<?, ?>> builds) {
        this.builds = builds;
    }
}

