/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.constraints;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.UriReport;
import hudson.plugins.performance.constraints.AbstractConstraint;
import hudson.plugins.performance.constraints.ConstraintDescriptor;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.TestCaseBlock;
import hudson.util.FormValidation;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AbsoluteConstraint
extends AbstractConstraint {
    private long value = 0L;

    @DataBoundConstructor
    public AbsoluteConstraint(AbstractConstraint.Metric meteredValue, AbstractConstraint.Operator operator, String relatedPerfReport, AbstractConstraint.Escalation escalationLevel, boolean success, TestCaseBlock testCaseBlock, long value) {
        super(meteredValue, operator, relatedPerfReport, escalationLevel, success, testCaseBlock);
        this.value = value;
    }

    @Override
    public AbsoluteConstraint clone() {
        AbsoluteConstraint clone = new AbsoluteConstraint(this.getMeteredValue(), this.getOperator(), this.getRelatedPerfReport(), this.getEscalationLevel(), this.getSuccess(), new TestCaseBlock(this.getTestCaseBlock().getTestCase()), this.getValue());
        return clone;
    }

    @Override
    public ConstraintEvaluation evaluate(List<? extends Run<?, ?>> builds) throws InvocationTargetException, AbortException {
        if (builds.isEmpty()) {
            throw new AbortException("Performance: No builds found to evaluate!");
        }
        this.checkForDefectiveParams(builds);
        PerformanceReport pr = ((PerformanceBuildAction)builds.get(0).getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getPerformanceReport(this.getRelatedPerfReport());
        double newValue = 0.0;
        if (!this.isSpecifiedTestCase()) {
            newValue = this.checkMetredValueforPerfReport(this.getMeteredValue(), pr);
        } else {
            List<UriReport> uriList = pr.getUriListOrdered();
            for (UriReport ur : uriList) {
                if (!this.getTestCaseBlock().getTestCase().equals(ur.getUri())) continue;
                newValue = this.checkMetredValueforUriReport(this.getMeteredValue(), ur);
                break;
            }
        }
        return this.check(newValue);
    }

    private ConstraintEvaluation check(double newValue) {
        String measuredLevel;
        switch (this.getOperator()) {
            case NOT_LESS: {
                if (newValue >= (double)this.getValue()) {
                    this.setSuccess(true);
                    break;
                }
                this.setSuccess(false);
                break;
            }
            case NOT_GREATER: {
                if (newValue <= (double)this.getValue()) {
                    this.setSuccess(true);
                    break;
                }
                this.setSuccess(false);
                break;
            }
            case NOT_EQUAL: {
                if (newValue != (double)this.getValue()) {
                    this.setSuccess(true);
                    break;
                }
                this.setSuccess(false);
            }
        }
        ConstraintEvaluation evaluation = new ConstraintEvaluation(this, this.getValue(), newValue);
        String string = measuredLevel = this.isSpecifiedTestCase() ? this.getTestCaseBlock().getTestCase() : "all test cases";
        if (this.getSuccess()) {
            this.setResultMessage("Absolute constraint successful! - Report: " + this.getRelatedPerfReport() + " \nThe constraint says: " + (Object)((Object)this.getMeteredValue()) + " of " + measuredLevel + " must " + this.getOperator().text + " " + this.getValue() + "\nMeasured value for " + (Object)((Object)this.getMeteredValue()) + ": " + newValue + "\nEscalation Level: " + (Object)((Object)this.getEscalationLevel()));
        } else {
            this.setResultMessage("Absolute constraint failed! - Report: " + this.getRelatedPerfReport() + " \nThe constraint says: " + (Object)((Object)this.getMeteredValue()) + " of " + measuredLevel + " must " + this.getOperator().text + " " + this.getValue() + "\nMeasured value for " + (Object)((Object)this.getMeteredValue()) + ": " + newValue + "\nEscalation Level: " + (Object)((Object)this.getEscalationLevel()));
        }
        return evaluation;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Extension
    public static class DescriptorImpl
    extends ConstraintDescriptor {
        public String getDisplayName() {
            return "Absolute Constraint";
        }

        public FormValidation doCheckRelatedPerfReport(@QueryParameter String relatedPerfReport) {
            if (StringUtils.isEmpty((String)relatedPerfReport)) {
                return FormValidation.error((String)"This field must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestCase(@QueryParameter String testCase) {
            if (StringUtils.isEmpty((String)testCase)) {
                return FormValidation.error((String)"This field must not be empty");
            }
            return FormValidation.ok();
        }
    }
}

