/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.plugins.performance.AbstractParser;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public class JmeterSummarizerParser
extends AbstractParser {
    public final String logDateFormat;

    @DataBoundConstructor
    public JmeterSummarizerParser(String glob, String logDateFormat) {
        super(glob);
        this.logDateFormat = logDateFormat == null || logDateFormat.length() == 0 ? this.getDefaultDatePattern() : logDateFormat;
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.log";
    }

    public String getDefaultDatePattern() {
        return "yyyy/mm/dd HH:mm:ss";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        PerformanceReport report = new PerformanceReport();
        report.setReportFileName(reportFile.getName());
        Scanner fileScanner = null;
        try {
            fileScanner = new Scanner(reportFile);
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.logDateFormat);
            String lastEqualsLine = null;
            while (fileScanner.hasNextLine()) {
                String line = fileScanner.nextLine();
                if (!line.contains("=") || !line.contains("jmeter.reporters.Summariser:")) continue;
                lastEqualsLine = line;
            }
            long reportSamples = Long.MIN_VALUE;
            long reportAvg = Long.MIN_VALUE;
            long reportMin = Long.MAX_VALUE;
            long reportMax = Long.MIN_VALUE;
            String reportErrorPercent = "";
            Scanner lineScanner = null;
            if (lastEqualsLine != null) {
                try {
                    lineScanner = new Scanner(lastEqualsLine);
                    Pattern delimiter = lineScanner.delimiter();
                    lineScanner.useDelimiter("INFO");
                    HttpSample sample = new HttpSample();
                    String dateString = lineScanner.next();
                    sample.setDate(dateFormat.parse(dateString));
                    lineScanner.findInLine("jmeter.reporters.Summariser:");
                    lineScanner.useDelimiter("\\=");
                    String key = lineScanner.next().trim();
                    lineScanner.useDelimiter(delimiter);
                    lineScanner.next();
                    reportSamples = lineScanner.nextLong();
                    sample.setSummarizerSamples(reportSamples);
                    lineScanner.findInLine("Avg:");
                    sample.setDuration(lineScanner.nextLong());
                    reportAvg = sample.getDuration();
                    sample.setSuccessful(true);
                    lineScanner.findInLine("Min:");
                    long sampleMin = lineScanner.nextLong();
                    sample.setSummarizerMin(sampleMin);
                    reportMin = Math.min(reportMin, sampleMin);
                    lineScanner.findInLine("Max:");
                    long sampleMax = lineScanner.nextLong();
                    sample.setSummarizerMax(sampleMax);
                    reportMax = Math.max(reportMax, sampleMax);
                    lineScanner.findInLine("Err:");
                    lineScanner.findInLine("\\(");
                    lineScanner.useDelimiter("%");
                    reportErrorPercent = lineScanner.next();
                    sample.setSummarizerErrors(Float.parseFloat(reportErrorPercent));
                    sample.setUri(key);
                    report.addSample(sample);
                }
                finally {
                    if (lineScanner != null) {
                        lineScanner.close();
                    }
                }
            }
            report.setSummarizerSize(reportSamples);
            report.setSummarizerAvg(reportAvg);
            report.setSummarizerMin(reportMin);
            report.setSummarizerMax(reportMax);
            report.setSummarizerErrors(reportErrorPercent);
            PerformanceReport performanceReport = report;
            return performanceReport;
        }
        finally {
            if (fileScanner != null) {
                fileScanner.close();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JmeterSummarizer";
        }
    }
}

