/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.reports;

import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.plugins.performance.constraints.AbsoluteConstraint;
import hudson.plugins.performance.constraints.AbstractConstraint;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.RelativeConstraint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import jenkins.model.Jenkins;

public class ConstraintReport {
    private File performanceLog;
    private Run<?, ?> newBuild;
    private int buildNumber;
    private Calendar buildDate;
    private Result buildResult;
    private String linkToBuild;
    private short allConstraints = 0;
    private short relativeConstraints = 0;
    private short absoluteConstraints = 0;
    private short successfulConstraints = 0;
    private short violatedConstraints = 0;
    private short violatedInformation = 0;
    private short violatedUnstable = 0;
    private short violatedError = 0;
    private String loggerMsg;
    private String loggerMsgAdv;
    private String junitReport;

    public ConstraintReport(ArrayList<ConstraintEvaluation> ceList, Run<?, ?> globBuild, boolean persistConstraintLog) throws IOException {
        this.newBuild = globBuild;
        this.createMetaData(ceList, this.newBuild);
        this.createLoggerMsg(ceList);
        this.createLoggerMsgAdv();
        this.writeResultsToEnvVar();
        if (persistConstraintLog) {
            this.writeResultsToFile();
        }
        this.junitReport = this.createJunitReport(ceList);
    }

    private void createMetaData(ArrayList<ConstraintEvaluation> ceList, Run<?, ?> newBuild) {
        this.buildNumber = newBuild.getNumber();
        this.buildDate = newBuild.getTimestamp();
        this.buildResult = this.determineBuildResult(ceList);
        this.linkToBuild = Jenkins.get().getRootUrl() == null ? "Could not resolve URL - Please set the root URL in the Jenkins System Configuration" : Jenkins.get().getRootUrl() + newBuild.getUrl();
        block10: for (ConstraintEvaluation ce : ceList) {
            if (ce.getAbstractConstraint() instanceof AbsoluteConstraint) {
                this.allConstraints = (short)(this.allConstraints + 1);
                this.absoluteConstraints = (short)(this.absoluteConstraints + 1);
                if (ce.getAbstractConstraint().getSuccess()) {
                    this.successfulConstraints = (short)(this.successfulConstraints + 1);
                    continue;
                }
                this.violatedConstraints = (short)(this.violatedConstraints + 1);
                switch (ce.getAbstractConstraint().getEscalationLevel().ordinal()) {
                    case 0: {
                        this.violatedInformation = (short)(this.violatedInformation + 1);
                        continue block10;
                    }
                    case 1: {
                        this.violatedUnstable = (short)(this.violatedUnstable + 1);
                        continue block10;
                    }
                    case 2: {
                        this.violatedError = (short)(this.violatedError + 1);
                        continue block10;
                    }
                }
                continue;
            }
            if (!(ce.getAbstractConstraint() instanceof RelativeConstraint)) continue;
            this.allConstraints = (short)(this.allConstraints + 1);
            this.relativeConstraints = (short)(this.relativeConstraints + 1);
            if (ce.getAbstractConstraint().getSuccess()) {
                this.successfulConstraints = (short)(this.successfulConstraints + 1);
                continue;
            }
            this.violatedConstraints = (short)(this.violatedConstraints + 1);
            switch (ce.getAbstractConstraint().getEscalationLevel().ordinal()) {
                case 0: {
                    this.violatedInformation = (short)(this.violatedInformation + 1);
                    break;
                }
                case 1: {
                    this.violatedUnstable = (short)(this.violatedUnstable + 1);
                    break;
                }
                case 2: {
                    this.violatedError = (short)(this.violatedError + 1);
                    break;
                }
            }
        }
    }

    private Result determineBuildResult(ArrayList<ConstraintEvaluation> ceList) {
        int highestViolatedEscalation = 0;
        for (ConstraintEvaluation ce : ceList) {
            if (ce.getAbstractConstraint().getEscalationLevel().ordinal() <= highestViolatedEscalation || ce.getAbstractConstraint().getSuccess()) continue;
            highestViolatedEscalation = ce.getAbstractConstraint().getEscalationLevel().ordinal();
        }
        switch (highestViolatedEscalation) {
            case 0: {
                return Result.SUCCESS;
            }
            case 1: {
                return Result.UNSTABLE;
            }
            case 2: {
                return Result.FAILURE;
            }
        }
        return Result.FAILURE;
    }

    private void createLoggerMsg(ArrayList<ConstraintEvaluation> ceList) {
        this.loggerMsg = "----------------------------------------------------------- \n";
        if (this.relativeConstraints == 0) {
            this.loggerMsg = this.loggerMsg + "There are no relative constraints to evaluate! \n-------------- \n";
        } else {
            this.loggerMsg = this.loggerMsg + "Evaluating all relative constraints! \n-------------- \n";
            for (ConstraintEvaluation ce : ceList) {
                if (!(ce.getAbstractConstraint() instanceof RelativeConstraint)) continue;
                this.loggerMsg = this.loggerMsg + ce.getAbstractConstraint().getResultMessage() + "\n-------------- \n";
            }
        }
        if (this.absoluteConstraints == 0) {
            this.loggerMsg = this.loggerMsg + "There are no absolute constraints to evaluate! \n-------------- \n";
        } else {
            this.loggerMsg = this.loggerMsg + "Evaluating all absolute constraints! \n-------------- \n";
            for (ConstraintEvaluation ce : ceList) {
                if (!(ce.getAbstractConstraint() instanceof AbsoluteConstraint)) continue;
                this.loggerMsg = this.loggerMsg + ce.getAbstractConstraint().getResultMessage() + "\n-------------- \n";
            }
        }
        if (this.violatedConstraints == 0) {
            this.loggerMsg = this.loggerMsg + "There were no failing Constraints! The build will be marked as SUCCESS";
        } else if (this.buildResult.equals(Result.SUCCESS)) {
            this.loggerMsg = this.loggerMsg + "The highest escalation: Information! The build will be marked as SUCCESS";
        } else if (this.buildResult.equals(Result.UNSTABLE)) {
            this.loggerMsg = this.loggerMsg + "The highest escalation: Warning! The build will be marked as UNSTABLE";
        } else if (this.buildResult.equals(Result.FAILURE)) {
            this.loggerMsg = this.loggerMsg + "The highest escalation: Error! The build will be marked as FAILURE";
        }
        this.loggerMsg = this.loggerMsg + "\n";
        if (this.violatedConstraints == 0) {
            return;
        }
        int maxUriColumnWidth = 8;
        int maxReportColumnWidth = 6;
        for (ConstraintEvaluation ce : ceList) {
            AbstractConstraint c = ce.getAbstractConstraint();
            maxUriColumnWidth = Math.max(c.isSpecifiedTestCase() ? c.getTestCaseBlock().getTestCase().length() : 0, maxUriColumnWidth);
            maxReportColumnWidth = Math.max(c.getRelatedPerfReport().length(), maxReportColumnWidth);
        }
        String logFormat = "%1$-" + maxReportColumnWidth + "s %2$-" + maxUriColumnWidth + "s %3$-10s %4$-20s %5$10s %6$-20s\n";
        this.loggerMsg = this.loggerMsg + "\nSummary of failed constraints:\n" + String.format(logFormat, "Report", "Testcase", "Metric", "Operator", "Value", "Level");
        for (ConstraintEvaluation ce : ceList) {
            AbstractConstraint c = ce.getAbstractConstraint();
            if (c.getSuccess()) continue;
            this.loggerMsg = this.loggerMsg + String.format(logFormat, c.getRelatedPerfReport(), c.isSpecifiedTestCase() ? c.getTestCaseBlock().getTestCase() : "*", c.getMeteredValue().toString(), c.getOperator().toString(), c instanceof RelativeConstraint ? String.format("%9.3f%%", ((RelativeConstraint)c).getTolerance()) : String.format("%10d", ((AbsoluteConstraint)c).getValue()), c.getEscalationLevel().toString());
        }
        this.loggerMsg = this.loggerMsg + "\n";
    }

    private void createLoggerMsgAdv() {
        this.loggerMsgAdv = "----------------------------------------------------------- \nBuild Number: #" + this.getBuildNumber() + "\nBuild Date: " + String.valueOf(this.getBuildDate().getTime()) + "\nBuild State: " + this.getBuildResult().toString() + "\nLink to build: " + this.linkToBuild + "\n-------------- \nNumber of all constraints: " + this.getAllConstraints() + "\nRelative constraints: " + this.getRelativeConstraints() + "\nAbsolute constraints: " + this.getAbsoluteConstraints() + "\nSuccessful constraints: " + this.getSuccessfulConstraints() + "\nViolated constraints: " + this.getViolatedConstraints() + "\n->INFORMATION: " + this.getViolatedInformation() + "\n->UNSTABLE: " + this.getViolatedUnstable() + "\n->ERROR: " + this.getViolatedError() + "\n-------------- \n" + this.loggerMsg + "\n";
    }

    private String createJunitReport(ArrayList<ConstraintEvaluation> ceList) {
        StringBuilder sb = new StringBuilder();
        sb.append("<testsuite tests=\"" + this.getAllConstraints() + "\" failures=\"" + this.getViolatedConstraints() + "\" >\n");
        for (ConstraintEvaluation ce : ceList) {
            AbstractConstraint c = ce.getAbstractConstraint();
            sb.append(c.getJunitResult());
        }
        sb.append("</testsuite>");
        return sb.toString();
    }

    public void writeResultsToFile() throws IOException {
        this.performanceLog = new File(String.valueOf(this.newBuild.getRootDir()) + File.separator + "performance-results" + File.separator + "performance.log");
        if (!this.performanceLog.exists()) {
            boolean dirsCreated = this.performanceLog.getParentFile().mkdirs();
            if (!dirsCreated && !this.performanceLog.getParentFile().exists()) {
                throw new IOException("Failed to create directory " + String.valueOf(this.performanceLog.getParentFile()));
            }
            if (!this.performanceLog.createNewFile()) {
                throw new IOException("Cannot create new file " + this.performanceLog.getAbsolutePath());
            }
        }
        try (FileOutputStream outWriter = new FileOutputStream(this.performanceLog, true);){
            outWriter.write(this.getLoggerMsgAdv().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeResultsToEnvVar() {
        ArrayList<StringParameterValue> params = new ArrayList<StringParameterValue>();
        params.add(new StringParameterValue("BUILD_CONSTRAINT_LOG", this.getLoggerMsgAdv()));
        this.newBuild.addAction((Action)new ParametersAction(params));
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public Calendar getBuildDate() {
        return this.buildDate;
    }

    public Result getBuildResult() {
        return this.buildResult;
    }

    public String getLinkToBuild() {
        return this.linkToBuild;
    }

    public short getAllConstraints() {
        return this.allConstraints;
    }

    public short getRelativeConstraints() {
        return this.relativeConstraints;
    }

    public short getAbsoluteConstraints() {
        return this.absoluteConstraints;
    }

    public short getSuccessfulConstraints() {
        return this.successfulConstraints;
    }

    public short getViolatedConstraints() {
        return this.violatedConstraints;
    }

    public short getViolatedInformation() {
        return this.violatedInformation;
    }

    public short getViolatedUnstable() {
        return this.violatedUnstable;
    }

    public short getViolatedError() {
        return this.violatedError;
    }

    public String getLoggerMsg() {
        return this.loggerMsg;
    }

    public String getLoggerMsgAdv() {
        return this.loggerMsgAdv;
    }

    public String getJunitReport() {
        return this.junitReport;
    }

    public File getPerformanceLog() {
        return this.performanceLog;
    }

    public void setPerformanceLog(File performanceLog) {
        this.performanceLog = performanceLog;
    }
}

