/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.TaurusFinalStats;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaurusParser
extends AbstractParser {
    public TaurusParser(String glob, String percentiles) {
        super(glob, percentiles, PerformanceReport.INCLUDE_ALL);
    }

    @DataBoundConstructor
    public TaurusParser(String glob, String percentiles, String filterRegex) {
        super(glob, percentiles, filterRegex);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.xml";
    }

    @Override
    protected PerformanceReport parse(File reportFile) throws Exception {
        return this.readFromXML(reportFile);
    }

    private PerformanceReport readFromXML(File reportFile) throws Exception {
        PerformanceReport report = this.createPerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setShowTrendGraphs(this.showTrendGraphs);
        report.setReportFileName(reportFile.getName());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(reportFile);
        doc.getDocumentElement().normalize();
        Node urlNode = doc.getElementsByTagName("ReportURL").item(0);
        if (urlNode != null) {
            this.reportURL = urlNode.getTextContent();
        }
        Node testDurationNode = doc.getElementsByTagName("TestDuration").item(0);
        Double testDuration = null;
        if (testDurationNode != null) {
            testDuration = Double.parseDouble(testDurationNode.getTextContent()) * 1000.0;
        }
        NodeList nList = doc.getElementsByTagName("Group");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            TaurusFinalStats statusReport = this.getTaurusFinalStats((Element)nNode);
            statusReport.setTestDuration(testDuration);
            if (!((Element)nNode).getAttribute("label").isEmpty()) {
                statusReport.setLabel(((Element)nNode).getAttribute("label"));
                report.addSample(statusReport, false);
                continue;
            }
            statusReport.setLabel("SUMMARY");
            report.addSample(statusReport, true);
        }
        return report;
    }

    private TaurusFinalStats getTaurusFinalStats(Element group) {
        TaurusFinalStats report = new TaurusFinalStats();
        report.setBytes(Long.parseLong(this.getValueAttribute("bytes", group)));
        report.setFail(Integer.parseInt(this.getValueAttribute("fail", group)));
        report.setSucc(Integer.parseInt(this.getValueAttribute("succ", group)));
        if (group.getElementsByTagName("throughput").getLength() > 0) {
            report.setThroughput(Long.parseLong(this.getValueAttribute("throughput", group)));
        }
        report.setAverageResponseTime(Double.parseDouble(this.getValueAttribute("avg_rt", group)) * 1000.0);
        NodeList perc = group.getElementsByTagName("perc");
        for (int i = 0; i < perc.getLength(); ++i) {
            Node nNode = perc.item(i);
            String attributeParam = ((Element)nNode).getAttribute("param");
            Double valueInMs = Double.valueOf(((Element)nNode).getAttribute("value")) * 1000.0;
            if ("50.0".equals(attributeParam)) {
                report.setPerc50(valueInMs);
                continue;
            }
            if ("90.0".equals(attributeParam)) {
                report.setPerc90(valueInMs);
                continue;
            }
            if ("95.0".equals(attributeParam)) {
                report.setPerc95(valueInMs);
                continue;
            }
            if ("0.0".equals(attributeParam)) {
                report.setPerc0(valueInMs);
                continue;
            }
            if (!"100.0".equals(attributeParam)) continue;
            report.setPerc100(valueInMs);
        }
        return report;
    }

    private String getValueAttribute(String elementName, Element group) {
        return ((Element)group.getElementsByTagName(elementName).item(0)).getAttribute("value");
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "Taurus";
        }
    }
}

