/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.performance.JMeterParser;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceProjectAction;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportMap;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformancePublisher
extends Recorder {
    private int errorFailedThreshold = 0;
    private int errorUnstableThreshold = 0;
    private boolean modePerformancePerTestCase = false;
    private transient String filename;
    private List<PerformanceReportParser> parsers;

    @DataBoundConstructor
    public PerformancePublisher(int errorFailedThreshold, int errorUnstableThreshold, boolean modePerformancePerTestCase, List<? extends PerformanceReportParser> parsers) {
        this.errorFailedThreshold = errorFailedThreshold;
        this.errorUnstableThreshold = errorUnstableThreshold;
        if (parsers == null) {
            parsers = Collections.emptyList();
        }
        this.parsers = new ArrayList<PerformanceReportParser>(parsers);
        this.modePerformancePerTestCase = modePerformancePerTestCase;
    }

    public static File getPerformanceReport(AbstractBuild<?, ?> build, String parserDisplayName, String performanceReportName) {
        return new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportFileRelativePath(parserDisplayName, PerformancePublisher.getPerformanceReportBuildFileName(performanceReportName)));
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PerformanceProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public List<PerformanceReportParser> getParsers() {
        return this.parsers;
    }

    public static String getPerformanceReportBuildFileName(String performanceReportWorkspaceName) {
        Pattern p;
        Matcher matcher;
        String result = performanceReportWorkspaceName;
        if (performanceReportWorkspaceName != null && (matcher = (p = Pattern.compile("-[0-9]*\\.xml")).matcher(performanceReportWorkspaceName)).find()) {
            result = matcher.replaceAll(".xml");
        }
        return result;
    }

    protected static List<FilePath> locatePerformanceReports(FilePath workspace, String includes) throws IOException, InterruptedException {
        String[] parts;
        try {
            String[] parts2 = includes.split("\\s*[;:,]+\\s*");
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            for (String path : parts2) {
                FilePath[] ret = workspace.list(path);
                if (ret.length <= 0) continue;
                files.addAll(Arrays.asList(ret));
            }
            if (!files.isEmpty()) {
                return files;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = includes.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/*")));
                continue;
            }
            files.add(src);
        }
        return files;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (this.errorUnstableThreshold >= 0 && this.errorUnstableThreshold <= 100) {
            logger.println("Performance: Percentage of errors greater or equal than " + this.errorUnstableThreshold + "% sets the build as " + Result.UNSTABLE.toString().toLowerCase());
        } else {
            logger.println("Performance: No threshold configured for making the test " + Result.UNSTABLE.toString().toLowerCase());
        }
        if (this.errorFailedThreshold >= 0 && this.errorFailedThreshold <= 100) {
            logger.println("Performance: Percentage of errors greater or equal than " + this.errorFailedThreshold + "% sets the build as " + Result.FAILURE.toString().toLowerCase());
        } else {
            logger.println("Performance: No threshold configured for making the test " + Result.FAILURE.toString().toLowerCase());
        }
        PerformanceBuildAction a = new PerformanceBuildAction(build, logger, this.parsers);
        build.addAction((Action)a);
        double thresholdTolerance = 1.0E-8;
        for (PerformanceReportParser parser : this.parsers) {
            String glob = parser.glob;
            logger.println("Performance: Recording " + parser.getReportName() + " reports '" + glob + "'");
            List<FilePath> files = PerformancePublisher.locatePerformanceReports(build.getWorkspace(), glob);
            if (files.isEmpty()) {
                if (build.getResult().isWorseThan(Result.UNSTABLE)) {
                    return true;
                }
                build.setResult(Result.FAILURE);
                logger.println("Performance: no " + parser.getReportName() + " files matching '" + glob + "' have been found. Has the report generated?. Setting Build to " + build.getResult());
                return true;
            }
            List<File> localReports = this.copyReportsToMaster(build, logger, files, parser.getDescriptor().getDisplayName());
            Collection<PerformanceReport> parsedReports = parser.parse(build, localReports, (TaskListener)listener);
            for (PerformanceReport r : parsedReports) {
                r.setBuildAction(a);
                double errorPercent = r.errorPercent();
                Result result = Result.SUCCESS;
                if (this.errorFailedThreshold >= 0 && errorPercent - (double)this.errorFailedThreshold > thresholdTolerance) {
                    result = Result.FAILURE;
                    build.setResult(Result.FAILURE);
                } else if (this.errorUnstableThreshold >= 0 && errorPercent - (double)this.errorUnstableThreshold > thresholdTolerance) {
                    result = Result.UNSTABLE;
                }
                if (result.isWorseThan(build.getResult())) {
                    build.setResult(result);
                }
                logger.println("Performance: File " + r.getReportFileName() + " reported " + errorPercent + "% of errors [" + result + "]. Build status is: " + build.getResult());
            }
        }
        return true;
    }

    private List<File> copyReportsToMaster(AbstractBuild<?, ?> build, PrintStream logger, List<FilePath> files, String parserDisplayName) throws IOException, InterruptedException {
        ArrayList<File> localReports = new ArrayList<File>();
        for (FilePath src : files) {
            File localReport = PerformancePublisher.getPerformanceReport(build, parserDisplayName, src.getName());
            if (src.isDirectory()) {
                logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
                continue;
            }
            src.copyTo(new FilePath(localReport));
            localReports.add(localReport);
        }
        return localReports;
    }

    public Object readResolve() {
        if (this.parsers == null) {
            this.parsers = new ArrayList<PerformanceReportParser>();
        }
        if (this.filename != null) {
            this.parsers.add(new JMeterParser(this.filename));
            this.filename = null;
        }
        return this;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public boolean isModePerformancePerTestCase() {
        return this.modePerformancePerTestCase;
    }

    public void setModePerformancePerTestCase(boolean modePerformancePerTestCase) {
        this.modePerformancePerTestCase = modePerformancePerTestCase;
    }

    public boolean getModePerformancePerTestCase() {
        return this.modePerformancePerTestCase;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.Publisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/performance/help.html";
        }

        public List<PerformanceReportParserDescriptor> getParserDescriptors() {
            return PerformanceReportParserDescriptor.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

