/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmeterSummarizerParser
extends PerformanceReportParser {
    public final String logDateFormat;

    @DataBoundConstructor
    public JmeterSummarizerParser(String glob, String logDateFormat) {
        super(glob);
        this.logDateFormat = logDateFormat == null || logDateFormat.length() == 0 ? this.getDefaultDatePattern() : logDateFormat;
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.log";
    }

    public String getDefaultDatePattern() {
        return "yyyy/mm/dd HH:mm:ss";
    }

    @Override
    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        PrintStream logger = listener.getLogger();
        for (File f : reports) {
            try {
                PerformanceReport r = new PerformanceReport();
                r.setReportFileName(f.getName());
                r.setReportFileName(f.getName());
                logger.println("Performance: Parsing JMeterSummarizer report file " + f.getName());
                Scanner s = new Scanner(f);
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.logDateFormat);
                while (s.hasNextLine()) {
                    String line = s.nextLine().replaceAll("=", " ");
                    if (!line.contains("+")) continue;
                    Scanner scanner = new Scanner(line);
                    Pattern delimiter = scanner.delimiter();
                    scanner.useDelimiter("INFO");
                    HttpSample sample = new HttpSample();
                    String dateString = scanner.next();
                    sample.setDate(dateFormat.parse(dateString));
                    scanner.findInLine("jmeter.reporters.Summariser:");
                    scanner.useDelimiter("\\+");
                    String key = scanner.next().trim();
                    scanner.useDelimiter(delimiter);
                    scanner.next();
                    sample.setSummarizerSamples(scanner.nextLong());
                    scanner.findInLine("Avg:");
                    sample.setDuration(scanner.nextLong());
                    sample.setSuccessful(true);
                    scanner.findInLine("Min:");
                    sample.setSummarizerMin(scanner.nextLong());
                    scanner.findInLine("Max:");
                    sample.setSummarizerMax(scanner.nextLong());
                    scanner.findInLine("Err:");
                    sample.setSummarizerErrors(scanner.nextInt());
                    sample.setUri(key);
                    r.addSample(sample);
                }
                result.add(r);
            }
            catch (FileNotFoundException e) {
                logger.println("File not found" + e.getMessage());
            }
            catch (SAXException e) {
                logger.println(e.getMessage());
            }
            catch (ParseException e) {
                logger.println(e.getMessage());
            }
            catch (IOException e) {
                logger.println(e.getMessage());
            }
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JmeterSummarizer";
        }
    }
}

