/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportPosition;
import hudson.plugins.performance.UriReport;
import java.io.IOException;
import java.util.ArrayList;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TrendReportGraphs
implements ModelObject {
    private AbstractBuild<?, ?> build;
    private String filename;
    private PerformanceReport performanceReport;
    private AbstractProject<?, ?> project;

    public TrendReportGraphs(AbstractProject<?, ?> project, AbstractBuild<?, ?> build, StaplerRequest request, String filename, PerformanceReport performanceReport) {
        this.build = build;
        this.filename = filename;
        this.performanceReport = performanceReport;
        this.project = project;
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        String uri;
        PerformanceReportPosition performanceReportPosition = new PerformanceReportPosition();
        request.bindParameters((Object)performanceReportPosition);
        PerformanceBuildAction performanceBuildAction = (PerformanceBuildAction)this.build.getAction(PerformanceBuildAction.class);
        if (performanceBuildAction != null && this.performanceReport != null && (uri = performanceReportPosition.getSummarizerTrendUri()) != null) {
            UriReport uriReport = this.performanceReport.getUriReportMap().get(uri);
            uriReport.doSummarizerTrendGraph(request, response);
        }
    }

    public ArrayList<String> getUris() {
        ArrayList<String> uriList = new ArrayList<String>();
        PerformanceReport report = this.getPerformanceReport();
        if (report != null) {
            uriList.addAll(report.getUriReportMap().keySet());
        }
        return uriList;
    }

    public UriReport getUriReport(String uri) {
        if (this.performanceReport != null) {
            return this.performanceReport.getUriReportMap().get(uri);
        }
        return ((PerformanceBuildAction)this.build.getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getUriReport(uri);
    }

    public String getDisplayName() {
        return Messages.TrendReportDetail_DisplayName();
    }

    public String getFilename() {
        return this.filename;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public PerformanceReport getPerformanceReport() {
        return this.performanceReport;
    }
}

