/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.Extension;
import hudson.plugins.performance.AbstractParser;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public class JmeterSummarizerParser
extends AbstractParser {
    public final String logDateFormat;

    @DataBoundConstructor
    public JmeterSummarizerParser(String glob, String logDateFormat) {
        super(glob);
        this.logDateFormat = logDateFormat == null || logDateFormat.length() == 0 ? this.getDefaultDatePattern() : logDateFormat;
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.log";
    }

    public String getDefaultDatePattern() {
        return "yyyy/mm/dd HH:mm:ss";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        PerformanceReport report = new PerformanceReport();
        report.setReportFileName(reportFile.getName());
        report.setReportFileName(reportFile.getName());
        Scanner s = null;
        try {
            s = new Scanner(reportFile);
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.logDateFormat);
            while (s.hasNextLine()) {
                String line = s.nextLine().replaceAll("=", " ");
                if (!line.contains("+") || !line.contains("jmeter.reporters.Summariser:")) continue;
                Scanner scanner = null;
                try {
                    scanner = new Scanner(line);
                    Pattern delimiter = scanner.delimiter();
                    scanner.useDelimiter("INFO");
                    HttpSample sample = new HttpSample();
                    String dateString = scanner.next();
                    sample.setDate(dateFormat.parse(dateString));
                    scanner.findInLine("jmeter.reporters.Summariser:");
                    scanner.useDelimiter("\\+");
                    String key = scanner.next().trim();
                    scanner.useDelimiter(delimiter);
                    scanner.next();
                    sample.setSummarizerSamples(scanner.nextLong());
                    scanner.findInLine("Avg:");
                    sample.setDuration(scanner.nextLong());
                    sample.setSuccessful(true);
                    scanner.findInLine("Min:");
                    sample.setSummarizerMin(scanner.nextLong());
                    scanner.findInLine("Max:");
                    sample.setSummarizerMax(scanner.nextLong());
                    scanner.findInLine("Err:");
                    sample.setSummarizerErrors(scanner.nextInt());
                    sample.setUri(key);
                    report.addSample(sample);
                }
                finally {
                    if (scanner == null) continue;
                    scanner.close();
                }
            }
            PerformanceReport performanceReport = report;
            return performanceReport;
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JmeterSummarizer";
        }
    }
}

