/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.plugins.performance.AbstractReport;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.UriReport;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceReport
extends AbstractReport
implements Serializable,
Comparable<PerformanceReport> {
    private static final long serialVersionUID = 675698410989941826L;
    private transient PerformanceBuildAction buildAction;
    private String reportFileName = null;
    private final Map<String, UriReport> uriReportMap = new LinkedHashMap<String, UriReport>();
    private PerformanceReport lastBuildReport;
    private transient List<Long> durationsSortedBySize = null;
    private transient List<UriReport> uriReportsOrdered = null;
    private int nbError = 0;
    private float summarizerErrors = 0.0f;
    private int size;
    private long totalDuration = 0L;
    private double totalSizeInKB = 0.0;
    private long max = Long.MIN_VALUE;
    private long min = Long.MAX_VALUE;

    public static String asStaplerURI(String uri) {
        return uri.replace("http:", "").replaceAll("/", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(HttpSample pHttpSample) throws SAXException {
        String uri = pHttpSample.getUri();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        String staplerUri = PerformanceReport.asStaplerURI(uri);
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            UriReport uriReport = this.uriReportMap.get(staplerUri);
            if (uriReport == null) {
                uriReport = new UriReport(staplerUri, uri);
                this.uriReportMap.put(staplerUri, uriReport);
            }
            uriReport.addHttpSample(pHttpSample);
            this.durationsSortedBySize = null;
            this.uriReportsOrdered = null;
        }
        if (!pHttpSample.isSuccessful()) {
            ++this.nbError;
        }
        this.summarizerErrors += pHttpSample.getSummarizerErrors();
        ++this.size;
        this.totalDuration += pHttpSample.getDuration();
        this.totalSizeInKB += pHttpSample.getSizeInKb();
        this.max = Math.max(pHttpSample.getDuration(), this.max);
        this.min = Math.min(pHttpSample.getDuration(), this.min);
    }

    @Override
    public int compareTo(PerformanceReport jmReport) {
        if (this == jmReport) {
            return 0;
        }
        return this.getReportFileName().compareTo(jmReport.getReportFileName());
    }

    @Override
    public int countErrors() {
        return this.nbError;
    }

    @Override
    public double errorPercent() {
        if (this.ifSummarizerParserUsed(this.reportFileName)) {
            if (this.uriReportMap.size() == 0) {
                return 0.0;
            }
            return this.summarizerErrors / (float)this.uriReportMap.size();
        }
        return this.size() == 0 ? 0.0 : (double)this.countErrors() / (double)this.size() * 100.0;
    }

    @Override
    public long getAverage() {
        if (this.size == 0) {
            return 0L;
        }
        return this.totalDuration / (long)this.size;
    }

    public double getAverageSizeInKb() {
        if (this.size == 0) {
            return 0.0;
        }
        return PerformanceReport.roundTwoDecimals(this.totalSizeInKB / (double)this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDurationAt(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Argument 'percentage' must be a value between 0 and 1 (inclusive)");
        }
        if (this.size == 0) {
            return 0L;
        }
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.durationsSortedBySize == null) {
                this.durationsSortedBySize = new ArrayList<Long>();
                for (UriReport currentReport : this.uriReportMap.values()) {
                    this.durationsSortedBySize.addAll(currentReport.getDurations());
                }
                Collections.sort(this.durationsSortedBySize);
            }
            return this.durationsSortedBySize.get((int)((double)this.durationsSortedBySize.size() * percentage));
        }
    }

    @Override
    public long get90Line() {
        return this.getDurationAt(0.9);
    }

    @Override
    public long getMedian() {
        return this.getDurationAt(0.5);
    }

    @Override
    public String getHttpCode() {
        return "";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public UriReport getDynamic(String token) throws IOException {
        return this.getUriReportMap().get(token);
    }

    @Override
    public long getMax() {
        return this.max;
    }

    public double getTotalTrafficInKb() {
        return PerformanceReport.roundTwoDecimals(this.totalSizeInKB);
    }

    @Override
    public long getMin() {
        return this.min;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UriReport> getUriListOrdered() {
        Map<String, UriReport> map = this.uriReportMap;
        synchronized (map) {
            if (this.uriReportsOrdered == null) {
                this.uriReportsOrdered = new ArrayList<UriReport>(this.uriReportMap.values());
                Collections.sort(this.uriReportsOrdered, Collections.reverseOrder());
            }
            return this.uriReportsOrdered;
        }
    }

    public Map<String, UriReport> getUriReportMap() {
        return this.uriReportMap;
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void setLastBuildReport(PerformanceReport lastBuildReport) {
        Map<String, UriReport> lastBuildUriReportMap = lastBuildReport.getUriReportMap();
        for (Map.Entry<String, UriReport> item : this.uriReportMap.entrySet()) {
            UriReport lastBuildUri = lastBuildUriReportMap.get(item.getKey());
            if (lastBuildUri == null) continue;
            item.getValue().addLastBuildUriReport(lastBuildUri);
        }
        this.lastBuildReport = lastBuildReport;
    }

    @Override
    public long getAverageDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getAverage() - this.lastBuildReport.getAverage();
    }

    @Override
    public long getMedianDiff() {
        if (this.lastBuildReport == null) {
            return 0L;
        }
        return this.getMedian() - this.lastBuildReport.getMedian();
    }

    @Override
    public double getErrorPercentDiff() {
        if (this.lastBuildReport == null) {
            return 0.0;
        }
        return this.errorPercent() - this.lastBuildReport.errorPercent();
    }

    @Override
    public String getLastBuildHttpCodeIfChanged() {
        return "";
    }

    @Override
    public int getSizeDiff() {
        if (this.lastBuildReport == null) {
            return 0;
        }
        return this.size() - this.lastBuildReport.size();
    }

    public boolean ifSummarizerParserUsed(String filename) {
        List<PerformanceReportParser> list = ((PerformancePublisher)this.buildAction.getBuild().getProject().getPublishersList().get(PerformancePublisher.class)).getParsers();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getDescriptor().getDisplayName().equals("JmeterSummarizer")) {
                String[] parts;
                String fileExt = list.get((int)i).glob;
                for (String path : parts = fileExt.split("\\s*[;:,]+\\s*")) {
                    if (!filename.endsWith(path.substring(5))) continue;
                    return true;
                }
                continue;
            }
            if (!list.get(i).getDescriptor().getDisplayName().equals("Iago")) continue;
            return true;
        }
        return false;
    }

    private static double roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(d));
    }
}

