/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.PerformanceReportParser;
import hudson.plugins.performance.PerformanceReportParserDescriptor;
import hudson.util.IOException2;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterParser
extends PerformanceReportParser {
    private static final Logger LOGGER = Logger.getLogger(JMeterParser.class.getName());
    private static final Cache<String, PerformanceReport> cache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    @DataBoundConstructor
    public JMeterParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.jtl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        PrintStream logger = listener.getLogger();
        Iterator<File> iterator = reports.iterator();
        while (iterator.hasNext()) {
            File f = iterator.next();
            try {
                PerformanceReport r;
                String fser = f.getPath() + ".serialized";
                ObjectInputStream in = null;
                Class<JMeterParser> clazz = JMeterParser.class;
                // MONITORENTER : hudson.plugins.performance.JMeterParser.class
                try {
                    r = (PerformanceReport)cache.getIfPresent((Object)fser);
                    if (r == null) {
                        in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fser)));
                        r = (PerformanceReport)in.readObject();
                        cache.put((Object)fser, (Object)r);
                    }
                    result.add(r);
                    continue;
                }
                catch (FileNotFoundException fne) {
                }
                catch (Exception unknown) {
                    LOGGER.log(Level.WARNING, "Reading serialized PerformanceReport instance from file '" + fser + "' failed.", unknown);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                    continue;
                }
                // MONITOREXIT : clazz
                SAXParser parser = factory.newSAXParser();
                r = new PerformanceReport();
                r.setReportFileName(f.getName());
                logger.println("Performance: Parsing JMeter report file " + f.getPath());
                parser.parse(f, new DefaultHandler(){
                    HttpSample currentSample;
                    int counter = 0;

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
                            HttpSample sample = new HttpSample();
                            sample.setDate(new Date(Long.valueOf(attributes.getValue("ts") != null ? attributes.getValue("ts") : attributes.getValue("timeStamp"))));
                            sample.setDuration(Long.valueOf(attributes.getValue("t") != null ? attributes.getValue("t") : attributes.getValue("time")));
                            sample.setSuccessful(Boolean.valueOf(attributes.getValue("s") != null ? attributes.getValue("s") : attributes.getValue("success")));
                            sample.setUri(attributes.getValue("lb") != null ? attributes.getValue("lb") : attributes.getValue("label"));
                            sample.setHttpCode(attributes.getValue("rc") != null && attributes.getValue("rc").length() <= 3 ? attributes.getValue("rc") : "0");
                            sample.setSizeInKb(attributes.getValue("by") != null ? Double.valueOf(attributes.getValue("by")) / 1024.0 : 0.0);
                            if (this.counter == 0) {
                                this.currentSample = sample;
                            }
                            ++this.counter;
                        }
                    }

                    public void endElement(String uri, String localName, String qName) {
                        if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
                            if (this.counter == 1) {
                                try {
                                    r.addSample(this.currentSample);
                                }
                                catch (SAXException e) {
                                    e.printStackTrace();
                                }
                            }
                            --this.counter;
                        }
                    }
                });
                result.add(r);
                ObjectOutputStream out = null;
                Class<JMeterParser> clazz2 = JMeterParser.class;
                // MONITORENTER : hudson.plugins.performance.JMeterParser.class
                try {
                    cache.put((Object)fser, (Object)r);
                    out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fser)));
                    out.writeObject(r);
                    continue;
                }
                catch (Exception unknown) {
                    LOGGER.log(Level.WARNING, "Saving serialized PerformanceReport instance to file '" + fser + "' failed.", unknown);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                    continue;
                }
                // MONITOREXIT : clazz2
            }
            catch (ParserConfigurationException e) {
                throw new IOException2("Failed to create parser ", (Throwable)e);
            }
            catch (SAXException e) {
                logger.println("Performance: Failed to parse " + f + ": " + e.getMessage());
            }
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeter";
        }
    }
}

