/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.model.Result;

public enum ResultCondition {
    SUCCESS("Stable"){

        @Override
        boolean isMet(Result result) {
            return result == Result.SUCCESS;
        }
    }
    ,
    UNSTABLE("Unstable"){

        @Override
        boolean isMet(Result result) {
            return result == Result.UNSTABLE;
        }
    }
    ,
    FAILED_OR_BETTER("Stable, unstable or failed, but not aborted"){

        @Override
        boolean isMet(Result result) {
            return result.isBetterOrEqualTo(Result.FAILURE);
        }
    }
    ,
    UNSTABLE_OR_BETTER("Stable or unstable but not failed"){

        @Override
        boolean isMet(Result result) {
            return result.isBetterOrEqualTo(Result.UNSTABLE);
        }
    }
    ,
    UNSTABLE_OR_WORSE("Unstable or Failed but not stable"){

        @Override
        boolean isMet(Result result) {
            return result.isWorseOrEqualTo(Result.UNSTABLE);
        }
    }
    ,
    FAILED("Failed"){

        @Override
        boolean isMet(Result result) {
            return result == Result.FAILURE;
        }
    }
    ,
    ALWAYS("Complete (always trigger)"){

        @Override
        boolean isMet(Result result) {
            return true;
        }
    };

    private final String displayName;

    private ResultCondition(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    abstract boolean isMet(Result var1);
}

