/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.TextParameterValue;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.ParameterizedTriggerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

public class PredefinedBuildParameters
extends AbstractBuildParameters {
    private final String properties;
    private final boolean textParamValueOnNewLine;

    @DataBoundConstructor
    public PredefinedBuildParameters(String properties, boolean textParamValueOnNewLine) {
        this.properties = properties;
        this.textParamValueOnNewLine = textParamValueOnNewLine;
    }

    public PredefinedBuildParameters(String properties) {
        this(properties, false);
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = this.getEnvironment(build, listener);
        Properties p = ParameterizedTriggerUtils.loadProperties(this.getProperties());
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String s = entry.getValue().toString();
            if (this.textParamValueOnNewLine && s.contains("\n")) {
                values.add(new TextParameterValue(entry.getKey().toString(), env.expand(s)));
                continue;
            }
            values.add(new StringParameterValue(entry.getKey().toString(), env.expand(s)));
        }
        return new ParametersAction(values);
    }

    public String getProperties() {
        return this.properties;
    }

    public boolean getTextParamValueOnNewLine() {
        return this.textParamValueOnNewLine;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Predefined parameters";
        }
    }
}

