/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildInfoExporterAction;
import hudson.plugins.parameterizedtrigger.DefaultParameterValuesActionsTransform;
import hudson.plugins.parameterizedtrigger.ParameterizedTriggerUtils;
import hudson.plugins.parameterizedtrigger.ProjectSpecificParameterValuesActionTransform;
import hudson.plugins.parameterizedtrigger.ProjectSpecificParametersActionFactory;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.plugins.parameterizedtrigger.SubProjectData;
import hudson.plugins.promoted_builds.Promotion;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTriggerConfig
implements Describable<BuildTriggerConfig> {
    private final List<AbstractBuildParameters> configs;
    private final List<AbstractBuildParameterFactory> configFactories;
    private String projects;
    private final ResultCondition condition;
    private boolean triggerWithNoParameters;

    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameterFactory> configFactories, List<AbstractBuildParameters> configs) {
        this.projects = projects;
        this.condition = condition;
        this.triggerWithNoParameters = triggerWithNoParameters;
        this.configFactories = configFactories;
        this.configs = Util.fixNull(configs);
    }

    @DataBoundConstructor
    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameters> configs) {
        this(projects, condition, triggerWithNoParameters, null, configs);
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, AbstractBuildParameters ... configs) {
        this(projects, condition, false, null, Arrays.asList(configs));
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, List<AbstractBuildParameterFactory> configFactories, AbstractBuildParameters ... configs) {
        this(projects, condition, false, configFactories, Arrays.asList(configs));
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public List<AbstractBuildParameterFactory> getConfigFactories() {
        return this.configFactories;
    }

    public String getProjects() {
        return this.projects;
    }

    public String getProjects(EnvVars env) {
        return env != null ? env.expand(this.projects) : this.projects;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public boolean getTriggerWithNoParameters() {
        return this.triggerWithNoParameters;
    }

    public List<AbstractProject> getProjectList(EnvVars env) {
        return this.getProjectList(null, env);
    }

    public List<AbstractProject> getProjectList(ItemGroup context, EnvVars env) {
        ArrayList<AbstractProject> projectList = new ArrayList<AbstractProject>();
        projectList.addAll(Items.fromNameList((ItemGroup)context, (String)this.getProjects(env), AbstractProject.class));
        return projectList;
    }

    public SubProjectData getProjectInfo(AbstractProject context) {
        SubProjectData subProjectData = new SubProjectData();
        BuildTriggerConfig.iterateBuilds(context, this.projects, subProjectData);
        subProjectData.getTriggered().removeAll(subProjectData.getDynamic());
        subProjectData.getTriggered().removeAll(subProjectData.getFixed());
        return subProjectData;
    }

    private static void iterateBuilds(AbstractProject context, String projects, SubProjectData subProjectData) {
        StringTokenizer stringTokenizer = new StringTokenizer(projects, ",");
        while (stringTokenizer.hasMoreTokens()) {
            subProjectData.getUnresolved().add(stringTokenizer.nextToken().trim());
        }
        int BACK_TRACK = 5;
        if (!subProjectData.getUnresolved().isEmpty()) {
            AbstractBuild currentBuild = (AbstractBuild)context.getLastBuild();
            if (currentBuild == null) {
                subProjectData.getFixed().addAll(Items.fromNameList((ItemGroup)context.getParent(), (String)projects, AbstractProject.class));
                for (AbstractProject staticProject : subProjectData.getFixed()) {
                    subProjectData.getUnresolved().remove(staticProject.getFullName());
                }
                return;
            }
            BuildTriggerConfig.resolveProject(currentBuild, subProjectData);
            currentBuild = (AbstractBuild)currentBuild.getPreviousBuild();
            for (int backTrackCount = 0; currentBuild != null && backTrackCount < 5; currentBuild = (AbstractBuild)currentBuild.getPreviousBuild(), ++backTrackCount) {
                BuildTriggerConfig.resolveProject(currentBuild, subProjectData);
            }
            if (currentBuild != null && context.getLastSuccessfulBuild() != null) {
                BuildTriggerConfig.resolveProject((AbstractBuild)context.getLastSuccessfulBuild(), subProjectData);
            }
        }
    }

    private static void resolveProject(AbstractBuild build, SubProjectData subProjectData) {
        Iterator<String> unsolvedProjectIterator = subProjectData.getUnresolved().iterator();
        while (unsolvedProjectIterator.hasNext()) {
            AbstractProject resolvedProject;
            String unresolvedProjectName = unsolvedProjectIterator.next();
            Set<AbstractProject> destinationSet = subProjectData.getFixed();
            if (unresolvedProjectName.contains("$")) {
                EnvVars env = null;
                try {
                    env = build != null ? build.getEnvironment() : null;
                }
                catch (IOException e) {
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                unresolvedProjectName = env != null ? env.expand(unresolvedProjectName) : unresolvedProjectName;
                destinationSet = subProjectData.getDynamic();
            }
            if ((resolvedProject = (AbstractProject)Jenkins.getInstance().getItem(unresolvedProjectName, build.getProject().getParent(), AbstractProject.class)) == null) continue;
            destinationSet.add(resolvedProject);
            unsolvedProjectIterator.remove();
        }
        if (build != null && build.getAction(BuildInfoExporterAction.class) != null) {
            String triggeredProjects = ((BuildInfoExporterAction)build.getAction(BuildInfoExporterAction.class)).getProjectListString(",");
            subProjectData.getTriggered().addAll(Items.fromNameList((ItemGroup)build.getParent().getParent(), (String)triggeredProjects, AbstractProject.class));
        }
    }

    List<Action> getBaseActions(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        return this.getBaseActions(this.configs, build, listener);
    }

    List<Action> getBaseActions(Collection<AbstractBuildParameters> configs, AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction params = null;
        for (AbstractBuildParameters config : configs) {
            Action a = config.getAction(build, listener);
            if (a instanceof ParametersAction) {
                params = params == null ? (ParametersAction)a : ParameterizedTriggerUtils.mergeParameters(params, (ParametersAction)a);
                continue;
            }
            if (a == null) continue;
            actions.add(a);
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    List<Action> getBuildActions(List<Action> baseActions, AbstractProject<?, ?> project) {
        ArrayList<Action> actions = new ArrayList<Action>(baseActions);
        ProjectSpecificParametersActionFactory transformer = new ProjectSpecificParametersActionFactory(new ProjectSpecificParameterValuesActionTransform(), new DefaultParameterValuesActionsTransform());
        return transformer.getProjectSpecificBuildActions(actions, project);
    }

    public List<Future<AbstractBuild>> perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        try {
            if (this.condition.isMet(build.getResult())) {
                ArrayList<Future<AbstractBuild>> futures = new ArrayList<Future<AbstractBuild>>();
                for (List<AbstractBuildParameters> addConfigs : this.getDynamicBuildParameters(build, listener)) {
                    List<Action> actions = this.getBaseActions((Collection<AbstractBuildParameters>)ImmutableList.builder().addAll(this.configs).addAll(addConfigs).build(), build, (TaskListener)listener);
                    for (AbstractProject project : this.getProjectList(build.getRootBuild().getProject().getParent(), env)) {
                        List<Action> list = this.getBuildActions(actions, project);
                        futures.add(this.schedule(build, project, list));
                    }
                }
                return futures;
            }
        }
        catch (AbstractBuildParameters.DontTriggerException e) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public ListMultimap<AbstractProject, Future<AbstractBuild>> perform2(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        try {
            if (this.getCondition().isMet(build.getResult())) {
                ArrayListMultimap futures = ArrayListMultimap.create();
                for (List<AbstractBuildParameters> addConfigs : this.getDynamicBuildParameters(build, listener)) {
                    List<Action> actions = this.getBaseActions((Collection<AbstractBuildParameters>)ImmutableList.builder().addAll(this.configs).addAll(addConfigs).build(), build, (TaskListener)listener);
                    for (AbstractProject project : this.getProjectList(build.getRootBuild().getProject().getParent(), env)) {
                        List<Action> list = this.getBuildActions(actions, project);
                        futures.put((Object)project, (Object)this.schedule(build, project, list));
                    }
                }
                return futures;
            }
        }
        catch (AbstractBuildParameters.DontTriggerException e) {
            // empty catch block
        }
        return ArrayListMultimap.create();
    }

    private List<List<AbstractBuildParameters>> getDynamicBuildParameters(AbstractBuild<?, ?> build, BuildListener listener) throws AbstractBuildParameters.DontTriggerException, IOException, InterruptedException {
        if (this.configFactories == null || this.configFactories.isEmpty()) {
            return ImmutableList.of((Object)ImmutableList.of());
        }
        ArrayList dynamicBuildParameters = Lists.newArrayList();
        dynamicBuildParameters.add(Collections.emptyList());
        for (AbstractBuildParameterFactory configFactory : this.configFactories) {
            ArrayList newDynParameters = Lists.newArrayList();
            List<AbstractBuildParameters> factoryParameters = configFactory.getParameters(build, (TaskListener)listener);
            if (factoryParameters.size() <= 0) continue;
            for (AbstractBuildParameters config : factoryParameters) {
                for (List dynamicBuildParameter : dynamicBuildParameters) {
                    newDynParameters.add(ImmutableList.builder().addAll((Iterable)dynamicBuildParameter).add((Object)config).build());
                }
            }
            dynamicBuildParameters = newDynParameters;
        }
        return dynamicBuildParameters;
    }

    protected Cause createUpstreamCause(AbstractBuild<?, ?> build) {
        if (Jenkins.getInstance().getPlugin("promoted-builds") != null && build instanceof Promotion) {
            Promotion promotion = (Promotion)build;
            return new Cause.UpstreamCause((Run)promotion.getTarget());
        }
        return new Cause.UpstreamCause(build);
    }

    protected Future schedule(AbstractBuild<?, ?> build, AbstractProject project, int quietPeriod, List<Action> list) throws InterruptedException, IOException {
        Cause cause = this.createUpstreamCause(build);
        return project.scheduleBuild2(quietPeriod, cause, list.toArray(new Action[list.size()]));
    }

    protected Future schedule(AbstractBuild<?, ?> build, AbstractProject project, List<Action> list) throws InterruptedException, IOException {
        return this.schedule(build, project, project.getQuietPeriod(), list);
    }

    private static String computeRelativeNamesAfterRenaming(String oldFullName, String newFullName, String relativeNames, ItemGroup<?> context) {
        if (!Jenkins.getVersion().isOlderThan(new VersionNumber("1.530"))) {
            return Items.computeRelativeNamesAfterRenaming((String)oldFullName, (String)newFullName, (String)relativeNames, context);
        }
        StringTokenizer tokens = new StringTokenizer(relativeNames, ",");
        ArrayList<String> newValue = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String relativeName = tokens.nextToken().trim();
            String canonicalName = Items.getCanonicalName(context, (String)relativeName);
            if (canonicalName.equals(oldFullName) || canonicalName.startsWith(oldFullName + "/")) {
                String newCanonicalName = newFullName + canonicalName.substring(oldFullName.length());
                newValue.add(BuildTriggerConfig.computeRelativeNameAfterRenaming(canonicalName, newCanonicalName, relativeName));
                continue;
            }
            newValue.add(relativeName);
        }
        return StringUtils.join(newValue, (String)",");
    }

    private static String computeRelativeNameAfterRenaming(String oldFullName, String newFullName, String relativeName) {
        String[] a = oldFullName.split("/");
        String[] n = newFullName.split("/");
        assert (a.length == n.length);
        Object[] r = relativeName.split("/");
        int j = a.length - 1;
        for (int i = r.length - 1; i >= 0; --i) {
            String part = r[i];
            if (part.equals("") && i == 0 || part.equals(".")) continue;
            if (part.equals("..")) {
                --j;
                continue;
            }
            if (!part.equals(a[j])) continue;
            r[i] = n[j];
            --j;
        }
        return StringUtils.join((Object[])r, (char)'/');
    }

    public boolean onJobRenamed(ItemGroup context, String oldName, String newName) {
        String newProjects = BuildTriggerConfig.computeRelativeNamesAfterRenaming(oldName, newName, this.projects, context);
        boolean changed = !this.projects.equals(newProjects);
        this.projects = newProjects;
        return changed;
    }

    public boolean onDeleted(ItemGroup context, String oldName) {
        ArrayList<String> newNames = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.projects, ",");
        ArrayList newValue = new ArrayList();
        while (tokens.hasMoreTokens()) {
            String relativeName = tokens.nextToken().trim();
            String fullName = Items.getCanonicalName((ItemGroup)context, (String)relativeName);
            if (fullName.equals(oldName)) continue;
            newNames.add(relativeName);
        }
        String newProjects = StringUtils.join(newNames, (String)",");
        boolean changed = !this.projects.equals(newProjects);
        this.projects = newProjects;
        return changed;
    }

    public Descriptor<BuildTriggerConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String toString() {
        return this.getClass().getName() + " [projects=" + this.projects + ", condition=" + (Object)((Object)this.condition) + ", configs=" + this.configs + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<BuildTriggerConfig> {
        public String getDisplayName() {
            return "";
        }

        public List<Descriptor<AbstractBuildParameters>> getBuilderConfigDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameters.class);
        }

        public List<Descriptor<AbstractBuildParameterFactory>> getBuilderConfigFactoryDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameterFactory.class);
        }

        public FormValidation doCheckProjects(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (!StringUtils.isNotBlank((String)projectName)) continue;
                Item item = Jenkins.getInstance().getItem(projectName, project, Item.class);
                if (item == null) {
                    return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)projectName, (Object)AbstractProject.findNearest((String)projectName).getName()));
                }
                if (!(item instanceof AbstractProject)) {
                    return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)projectName));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error((String)"No project specified");
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteProjects(@QueryParameter String value, @AncestorInPath ItemGroup context) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            List jobs = Jenkins.getInstance().getAllItems(Job.class);
            for (Job job : jobs) {
                String relativeName = job.getRelativeNameFrom(context);
                if (!relativeName.startsWith(value) || !job.hasPermission(Item.READ)) continue;
                candidates.add(relativeName);
            }
            return candidates;
        }
    }
}

