/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.filters.StringInputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBuildParameters
extends AbstractBuildParameters {
    private final String propertiesFile;
    private final boolean failTriggerOnMissing;

    @DataBoundConstructor
    public FileBuildParameters(String propertiesFile, boolean failTriggerOnMissing) {
        this.propertiesFile = propertiesFile;
        this.failTriggerOnMissing = failTriggerOnMissing;
    }

    public FileBuildParameters(String propertiesFile) {
        this(propertiesFile, false);
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        EnvVars env = this.getEnvironment(build, listener);
        String resolvedPropertiesFile = env.expand(this.propertiesFile);
        String[] allFiles = Util.tokenize((String)resolvedPropertiesFile, (String)",");
        ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
        for (String file : allFiles) {
            FilePath f = build.getWorkspace().child(file);
            if (!f.exists()) {
                listener.getLogger().println("[parameterizedtrigger] Properties file " + file + " did not exist.");
                if (!this.getFailTriggerOnMissing()) continue;
                listener.getLogger().println("Not triggering due to missing file");
                throw new AbstractBuildParameters.DontTriggerException();
            }
            String s = f.readToString();
            s = env.expand(s);
            Properties p = new Properties();
            p.load((InputStream)new StringInputStream(s));
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                values.add(new StringParameterValue(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
        return values.size() == 0 ? null : new ParametersAction(values);
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public boolean getFailTriggerOnMissing() {
        return this.failTriggerOnMissing;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Parameters from properties file";
        }
    }
}

