/*
 * Decompiled with CFR 0.152.
 */
package com.opsgenie.integration.jenkins.pipeline;

import com.opsgenie.integration.jenkins.AlertPriority;
import com.opsgenie.integration.jenkins.AlertProperties;
import com.opsgenie.integration.jenkins.OpsGenieNotificationRequest;
import com.opsgenie.integration.jenkins.OpsGenieNotificationService;
import com.opsgenie.integration.jenkins.OpsGenieNotifier;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OpsGenieTriggerStep
extends AbstractStepImpl {
    @Nonnull
    private boolean enable;
    private boolean notifyBuildStart;
    private String tags;
    private String apiKey;
    private String apiUrl;
    private String teams;
    private String priority;
    private String buildStartPriority;

    public boolean getEnable() {
        return this.enable;
    }

    @DataBoundSetter
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean getNotifyBuildStart() {
        return this.notifyBuildStart;
    }

    @DataBoundSetter
    public void setNotifyBuildStart(boolean notifyBuildStart) {
        this.notifyBuildStart = notifyBuildStart;
    }

    @DataBoundSetter
    public void setTags(String tags) {
        this.tags = tags;
    }

    @DataBoundSetter
    public void setTeams(String teams) {
        this.teams = teams;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @DataBoundSetter
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @DataBoundSetter
    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getTags() {
        return this.tags;
    }

    public String getTeams() {
        return this.teams;
    }

    public String getPriority() {
        return this.priority;
    }

    @DataBoundSetter
    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getBuildStartPriority() {
        return this.buildStartPriority;
    }

    @DataBoundSetter
    public void setBuildStartPriority(String buildStartPriority) {
        this.buildStartPriority = buildStartPriority;
    }

    @DataBoundConstructor
    public OpsGenieTriggerStep() {
    }

    public static class OpsGenieTriggerStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        @Inject
        transient OpsGenieTriggerStep step;
        @StepContextParameter
        transient TaskListener listener;
        @StepContextParameter
        private transient Run<?, ?> build;
        @StepContextParameter
        private transient Launcher launcher;

        protected String run() throws Exception {
            Jenkins jenkins;
            try {
                jenkins = Jenkins.getInstance();
            }
            catch (NullPointerException ne) {
                this.listener.error("ERROR?!");
                return null;
            }
            OpsGenieNotifier.DescriptorImpl ogDesc = (OpsGenieNotifier.DescriptorImpl)jenkins.getDescriptorByType(OpsGenieNotifier.DescriptorImpl.class);
            String tagsGiven = Util.fixNull((String)this.step.tags).isEmpty() ? ogDesc.getTags() : this.step.tags;
            String teamsGiven = Util.fixNull((String)this.step.teams).isEmpty() ? ogDesc.getTeams() : this.step.teams;
            AlertPriority alertPriority = AlertPriority.fromDisplayName(this.step.priority);
            AlertPriority notifyBuildStartPriority = AlertPriority.fromDisplayName(this.step.buildStartPriority);
            AlertProperties alertProperties = new AlertProperties().setTags(tagsGiven).setTeams(teamsGiven).setPriority(alertPriority).setBuildStartPriority(notifyBuildStartPriority);
            String apiKeyGiven = Util.fixNull((String)this.step.apiKey).isEmpty() ? ogDesc.getApiKey() : this.step.apiKey;
            String apiUrlGiven = Util.fixNull((String)this.step.apiUrl).isEmpty() ? ogDesc.getApiUrl() : this.step.apiUrl;
            OpsGenieNotificationRequest request = new OpsGenieNotificationRequest().setAlertProperties(alertProperties).setBuild(this.build).setListener(this.listener).setApiKey(apiKeyGiven).setApiUrl(apiUrlGiven);
            OpsGenieNotificationService ogService = new OpsGenieNotificationService(request);
            ogService.sendAfterBuildData();
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(OpsGenieTriggerStepExecution.class);
        }

        public String getFunctionName() {
            return "opsgenie";
        }

        @Nonnull
        public String getDisplayName() {
            return "OpsGenie step";
        }
    }
}

