/*
 * Decompiled with CFR 0.152.
 */
package com.opsgenie.integration.jenkins;

import com.opsgenie.integration.jenkins.AlertPriority;
import com.opsgenie.integration.jenkins.AlertProperties;
import com.opsgenie.integration.jenkins.OpsGenieNotificationRequest;
import com.opsgenie.integration.jenkins.OpsGenieNotificationService;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class OpsGenieNotifier
extends Notifier {
    public static final AlertPriority[] ALERT_PRIORITIES = AlertPriority.values();
    private static final String DEFAULT_API_URL = "https://api.opsgenie.com/";
    private boolean enable = true;
    private String tags;
    private boolean notifyBuildStart;
    private String apiKey;
    private String apiUrl;
    private String teams;
    private AlertPriority alertPriority;
    private AlertPriority notifyBuildStartPriority;

    @DataBoundConstructor
    public OpsGenieNotifier(boolean enable, boolean notifyBuildStart, String tags, String apiKey, String apiUrl, String teams, String alertPriority, String buildStartAlertPriority) {
        this.enable = enable;
        this.notifyBuildStart = notifyBuildStart;
        this.tags = tags;
        this.apiKey = apiKey;
        this.apiUrl = apiUrl;
        this.teams = teams;
        this.alertPriority = AlertPriority.fromDisplayName(alertPriority);
        this.notifyBuildStartPriority = AlertPriority.fromDisplayName(buildStartAlertPriority);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!this.isEnable()) {
            return true;
        }
        OpsGenieNotificationService service = this.createOpsGenieNotificationService(build, listener);
        return service.sendAfterBuildData();
    }

    private OpsGenieNotificationService createOpsGenieNotificationService(AbstractBuild<?, ?> build, BuildListener listener) {
        String tagsGiven = Util.fixNull((String)this.tags).isEmpty() ? this.getDescriptor().getTags() : this.tags;
        String teamsGiven = Util.fixNull((String)this.teams).isEmpty() ? this.getDescriptor().getTeams() : this.teams;
        AlertProperties alertProperties = new AlertProperties().setTags(tagsGiven).setTeams(teamsGiven).setPriority(this.alertPriority).setBuildStartPriority(this.notifyBuildStartPriority);
        String apiKeyGiven = Util.fixNull((String)this.apiKey).isEmpty() ? this.getDescriptor().getApiKey() : this.apiKey;
        String apiUrlGiven = Util.fixNull((String)this.apiUrl).isEmpty() ? this.getDescriptor().getApiUrl() : this.apiUrl;
        OpsGenieNotificationRequest request = new OpsGenieNotificationRequest().setAlertProperties(alertProperties).setBuild((Run<?, ?>)build).setListener((TaskListener)listener).setApiKey(apiKeyGiven).setApiUrl(apiUrlGiven);
        return new OpsGenieNotificationService(request);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        if (!this.isEnable() || !this.isNotifyBuildStart()) {
            return true;
        }
        OpsGenieNotificationService opsGenieNotificationService = this.createOpsGenieNotificationService(build, listener);
        return opsGenieNotificationService.sendPreBuildPayload();
    }

    public String toString() {
        return "OpsGenieNotifier{disable=" + this.enable + ", notifyBuildStart=" + this.notifyBuildStart + ", tags='" + this.tags + '\'' + ", apiKey='" + this.apiKey + '\'' + ", teams='" + this.teams + '\'' + '}';
    }

    @Exported
    public boolean isEnable() {
        return this.enable;
    }

    @Exported
    public boolean isNotifyBuildStart() {
        return this.notifyBuildStart;
    }

    @Exported
    public String getApiKey() {
        return this.apiKey;
    }

    @Exported
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Exported
    public String getTags() {
        return this.tags;
    }

    @Exported
    public String getTeams() {
        return this.teams;
    }

    @Exported
    public AlertPriority getNotifyBuildStartPriority() {
        return this.notifyBuildStartPriority;
    }

    @Exported
    public AlertPriority getAlertPriority() {
        return this.alertPriority;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String apiKey;
        private String teams;
        private String tags;
        private String apiUrl;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Send Alert to OpsGenie";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.apiKey = formData.getString("apiKey");
            this.apiUrl = formData.getString("apiUrl");
            this.tags = formData.getString("tags");
            this.teams = formData.getString("teams");
            this.save();
            return super.configure(req, formData);
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public String getApiUrl() {
            if (StringUtils.isBlank((String)this.apiUrl)) {
                this.apiUrl = OpsGenieNotifier.DEFAULT_API_URL;
            }
            return this.apiUrl;
        }

        public String getTeams() {
            return this.teams;
        }

        public String getTags() {
            return this.tags;
        }

        public String toString() {
            return "DescriptorImpl{apiKey='" + this.apiKey + '\'' + ", teams='" + this.teams + '\'' + ", tags='" + this.tags + '\'' + '}';
        }
    }
}

