/*
 * Decompiled with CFR 0.152.
 */
package com.opsgenie.integration.jenkins;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opsgenie.integration.jenkins.AlertProperties;
import com.opsgenie.integration.jenkins.OpsGenieNotificationRequest;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpsGenieNotificationService {
    private static final String INTEGRATION_PATH = "/v1/json/jenkins";
    private final Logger logger = LoggerFactory.getLogger(OpsGenieNotificationService.class);
    private Run<?, ?> build;
    private Job<?, ?> project;
    private AlertProperties alertProperties;
    private PrintStream consoleOutputLogger;
    private Map<String, Object> requestPayload;
    private ObjectMapper mapper;
    private OpsGenieNotificationRequest request;

    public OpsGenieNotificationService(OpsGenieNotificationRequest request) {
        this.build = request.getBuild();
        this.project = this.build.getParent();
        this.request = request;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.requestPayload = new HashMap<String, Object>();
        this.alertProperties = request.getAlertProperties();
        this.consoleOutputLogger = request.getListener().getLogger();
    }

    private boolean checkResponse(String res) {
        try {
            ResponseFromOpsGenie response = (ResponseFromOpsGenie)this.mapper.readValue(res, ResponseFromOpsGenie.class);
            if (StringUtils.isEmpty((String)response.error)) {
                this.consoleOutputLogger.println("Sending job data to OpsGenie is done");
                return true;
            }
            this.consoleOutputLogger.println("Response status is failed");
            this.logger.error("Response status is failed");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(this.consoleOutputLogger);
            this.logger.error("Exception while checking response" + e.getMessage());
            return !res.isEmpty();
        }
    }

    private String sendWebhookToOpsGenie(String data) {
        try {
            String apiUrl = this.request.getApiUrl();
            String apiKey = this.request.getApiKey();
            URI inputURI = new URI(apiUrl);
            String scheme = "https";
            String host = apiUrl;
            if (inputURI.isAbsolute()) {
                scheme = inputURI.getScheme();
                host = inputURI.getHost();
            }
            URI uri = new URIBuilder().setScheme(scheme).setHost(host).setPath(INTEGRATION_PATH).addParameter("apiKey", apiKey).build();
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost(uri);
            StringEntity params = new StringEntity(data);
            post.addHeader("content-type", "application/x-www-form-urlencoded");
            post.setEntity((HttpEntity)params);
            this.consoleOutputLogger.println("Sending job data to OpsGenie...");
            HttpResponse response = client.execute((HttpUriRequest)post);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace(this.consoleOutputLogger);
            this.logger.error("Exception while sending webhook: " + e.getMessage());
            return "";
        }
    }

    protected boolean sendPreBuildPayload() {
        this.populateRequestPayloadWithMandatoryFields();
        this.requestPayload.put("isPreBuild", "true");
        if (this.alertProperties.getBuildStartPriority() != null) {
            this.requestPayload.put("priority", this.alertProperties.getBuildStartPriority().getValue());
        }
        String payload = "";
        try {
            payload = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.requestPayload);
        }
        catch (Exception e) {
            e.printStackTrace(this.consoleOutputLogger);
            this.logger.error("Exception while serializing pre request:" + e.getMessage());
        }
        String response = this.sendWebhookToOpsGenie(payload);
        return this.checkResponse(response);
    }

    private String formatCommitList(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet) {
        StringBuilder commitListBuilder = new StringBuilder();
        if (changeLogSet.isEmptySet()) {
            commitListBuilder.append("No changes.\n\n");
        }
        for (ChangeLogSet.Entry entry : changeLogSet) {
            commitListBuilder.append(entry.getMsg()).append(" - <strong>").append(entry.getAuthor().getDisplayName()).append("</strong><br>\n");
        }
        return commitListBuilder.toString();
    }

    private String formatFailedTests(List<? extends TestResult> failedTests) {
        StringBuilder testResultBuilder = new StringBuilder();
        for (TestResult testResult : failedTests) {
            testResultBuilder.append(String.format("<strong>%s</strong>%n", testResult.getFullName()));
            if (StringUtils.isNotBlank((String)testResult.getErrorDetails())) {
                testResultBuilder.append(testResult.getErrorDetails());
            }
            testResultBuilder.append("\n\n");
        }
        return testResultBuilder.toString();
    }

    private String formatBuildVariables() {
        StringBuilder buildVariablesBuilder = new StringBuilder();
        if (this.build instanceof AbstractBuild) {
            Map buildVariables = ((AbstractBuild)this.build).getBuildVariables();
            for (Map.Entry entry : buildVariables.entrySet()) {
                buildVariablesBuilder.append((String)entry.getKey()).append(" -> ").append((String)entry.getValue()).append("\n");
            }
        }
        return buildVariablesBuilder.toString();
    }

    public boolean sendAfterBuildData() {
        Run previousBuild;
        Set culprits;
        this.populateRequestPayloadWithMandatoryFields();
        if (this.build instanceof AbstractBuild && (this.build.getResult() == Result.FAILURE || this.build.getResult() == Result.UNSTABLE) && !(culprits = ((AbstractBuild)this.build).getCulprits()).isEmpty()) {
            this.requestPayload.put("culprits", this.formatCulprits(culprits));
        }
        StringBuilder descriptionBuilder = new StringBuilder();
        AbstractTestResultAction testResult = (AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class);
        if (testResult != null) {
            String passedTestCount = Integer.toString(testResult.getTotalCount() - testResult.getFailCount() - testResult.getSkipCount());
            this.requestPayload.put("passedTestCount", passedTestCount);
            String failedTestCount = Integer.toString(testResult.getFailCount());
            this.requestPayload.put("failedTestCount", failedTestCount);
            String skippedTestCount = Integer.toString(testResult.getSkipCount());
            this.requestPayload.put("skippedTestCount", skippedTestCount);
            if (this.build.getResult() == Result.UNSTABLE || this.build.getResult() == Result.FAILURE) {
                descriptionBuilder.append(this.formatFailedTests(testResult.getFailedTests()));
                this.requestPayload.put("failedTests", descriptionBuilder);
            }
        }
        if (this.build instanceof AbstractBuild) {
            this.requestPayload.put("commitList", this.formatCommitList((ChangeLogSet<? extends ChangeLogSet.Entry>)((AbstractBuild)this.build).getChangeSet()));
        }
        if ((previousBuild = this.build.getPreviousBuild()) != null) {
            Job previousProject;
            String previousDisplayName = previousBuild.getDisplayName();
            this.requestPayload.put("previousDisplayName", previousDisplayName);
            String previousTime = previousBuild.getTimestamp().getTime().toString();
            this.requestPayload.put("previousTime", previousTime);
            Result previousResult = previousBuild.getResult();
            if (previousResult != null) {
                this.requestPayload.put("previousStatus", previousResult.toString());
            }
            if ((previousProject = previousBuild.getParent()) != null) {
                String previousProjectName = previousProject.getName();
                this.requestPayload.put("previousProjectName", previousProjectName);
            }
        }
        this.requestPayload.put("isPreBuild", "false");
        this.requestPayload.put("duration", this.build.getDurationString());
        this.requestPayload.put("params", this.formatBuildVariables());
        if (this.alertProperties.getPriority() != null) {
            this.requestPayload.put("priority", this.alertProperties.getPriority().getValue());
        }
        String payload = "";
        try {
            payload = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.requestPayload);
        }
        catch (Exception e) {
            e.printStackTrace(this.consoleOutputLogger);
            this.logger.error("Exception while serializing post request :" + e.getMessage());
        }
        String response = this.sendWebhookToOpsGenie(payload);
        return this.checkResponse(response);
    }

    private String formatCulprits(Set<User> culprits) {
        StringBuilder culpritsBuilder = new StringBuilder();
        for (User culprit : culprits) {
            culpritsBuilder.append(culprit.getFullName()).append(",");
        }
        return culpritsBuilder.toString();
    }

    private void populateRequestPayloadWithMandatoryFields() {
        String time = Objects.toString(this.build.getTimestamp().getTime());
        this.requestPayload.put("time", time);
        String projectName = this.project.getName();
        this.requestPayload.put("projectName", projectName);
        String displayName = this.build.getDisplayName();
        this.requestPayload.put("displayName", displayName);
        Result status = this.build.getResult();
        if (status == null) {
            status = Result.SUCCESS;
        }
        this.requestPayload.put("status", Objects.toString(status));
        String url = this.build.getUrl();
        this.requestPayload.put("url", JenkinsLocationConfiguration.get().getUrl() + url);
        List<String> tags = this.splitStringWithComma(this.alertProperties.getTags());
        this.requestPayload.put("tags", tags);
        List<String> teams = this.splitStringWithComma(this.alertProperties.getTeams());
        this.requestPayload.put("teams", teams);
        String startTime = Objects.toString(this.build.getStartTimeInMillis());
        this.requestPayload.put("startTimeInMillis", startTime);
    }

    private List<String> splitStringWithComma(String unparsed) {
        if (unparsed == null) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : unparsed.trim().split(",")) {
            tokens.add(token.trim());
        }
        return tokens;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResponseFromOpsGenie {
        @JsonProperty(value="error")
        private String error;

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}

