/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template.utils;

import com.arkea.jenkins.openstack.heat.orchestration.template.Bundle;
import com.arkea.jenkins.openstack.heat.orchestration.template.Output;
import com.arkea.jenkins.openstack.heat.orchestration.template.Parameter;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.ConstraintUtils;
import com.arkea.jenkins.openstack.heat.orchestration.template.utils.TypeMapperUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONObject;

public class BundleMapperUtils {
    public static Bundle getBundleFromJson(String data) throws JsonParseException, JsonMappingException, IOException {
        JSONObject json = JSONObject.fromObject((Object)data);
        Bundle bundle = new Bundle(json.getString("hotName"), json.getString("name"), json.getString("tags"), json.getBoolean("tag"), json.getBoolean("exist"), json.getBoolean("debug"));
        bundle.setTags(json.getString("tags"));
        bundle.setTag(json.getBoolean("tag"));
        TreeMap<String, Parameter> params = new TreeMap<String, Parameter>();
        JSONObject parameters = json.getJSONObject("parameters");
        for (Map.Entry entry : parameters.entrySet()) {
            Map properties = (Map)entry.getValue();
            Parameter param = new Parameter((String)properties.get("name"), TypeMapperUtils.getType((String)properties.get("type")), (String)properties.get("label"), (String)properties.get("description"), properties.get("defaultValue"), (Boolean)properties.get("hidden"), (String)properties.get("value"), ConstraintUtils.getContraintsFromJSONParameter(properties));
            params.put((String)entry.getKey(), param);
        }
        bundle.setParameters(params);
        TreeMap<String, Output> exits = new TreeMap<String, Output>();
        JSONObject outputs = json.getJSONObject("outputs");
        for (Map.Entry entry : outputs.entrySet()) {
            Map properties = (Map)entry.getValue();
            Output exit = new Output((String)properties.get("name"), (String)properties.get("description"), (String)properties.get("value"));
            exits.put((String)entry.getKey(), exit);
        }
        bundle.setOutputs(exits);
        return bundle;
    }
}

