/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template.constraints;

import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.AbstractConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.AllowedPatternConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.AllowedValuesConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.CustomConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.LengthConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.RangeConstraint;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstraintUtils {
    public static Map<String, AbstractConstraint> getContraintsToPopulatParameters(Map<String, Object> properties) {
        HashMap<String, AbstractConstraint> constraints = new HashMap<String, AbstractConstraint>();
        if (properties != null && properties.get("constraints") != null) {
            List cons = (List)properties.get("constraints");
            for (Map entry : cons) {
                AbstractConstraint constraint = ConstraintUtils.populateConstraint(entry);
                constraints.put(constraint.getType().getConstraintTypeName(), ConstraintUtils.populateConstraint(entry));
            }
        }
        return constraints;
    }

    private static AbstractConstraint populateConstraint(Map<String, Object> jsonConstraint) {
        AbstractConstraint constraints = null;
        String description = "";
        for (Map.Entry<String, Object> entry : jsonConstraint.entrySet()) {
            switch (entry.getKey()) {
                case "allowed_values": {
                    HashMap<String, String> allowedValues = new HashMap<String, String>();
                    for (Object value : (ArrayList)entry.getValue()) {
                        allowedValues.put(value.toString(), value.toString());
                    }
                    constraints = new AllowedValuesConstraint(allowedValues);
                    break;
                }
                case "length": {
                    constraints = new LengthConstraint();
                    Map lengthList = (Map)entry.getValue();
                    if (lengthList.get("min") != null) {
                        ((LengthConstraint)constraints).getLimits().put("min", (Integer)lengthList.get("min"));
                    }
                    if (lengthList.get("max") == null) break;
                    ((LengthConstraint)constraints).getLimits().put("max", (Integer)lengthList.get("max"));
                    break;
                }
                case "range": {
                    Map rangeList = (Map)entry.getValue();
                    constraints = new RangeConstraint();
                    if (rangeList.get("min") != null) {
                        ((RangeConstraint)constraints).getLimits().put("min", (Double)rangeList.get("min"));
                    }
                    if (rangeList.get("max") == null) break;
                    ((RangeConstraint)constraints).getLimits().put("max", (Double)rangeList.get("max"));
                    break;
                }
                case "allowed_pattern": {
                    constraints = new AllowedPatternConstraint((String)entry.getValue());
                    break;
                }
                case "custom_constraint": {
                    constraints = new CustomConstraint((String)entry.getValue());
                    break;
                }
                case "description": {
                    description = (String)entry.getValue();
                }
            }
        }
        constraints.setDescription(description);
        return constraints;
    }

    public static Map<String, AbstractConstraint> getContraintsFromJSONParameter(Map<String, Object> properties) throws JsonParseException, JsonMappingException, IOException {
        HashMap<String, AbstractConstraint> constraints = new HashMap<String, AbstractConstraint>();
        if (properties.get("constraints") != null && !"null".equals(properties.get("constraints").toString())) {
            Map cons = (Map)properties.get("constraints");
            ObjectMapper objMap = new ObjectMapper();
            for (Map.Entry entry : cons.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "allowed_pattern": {
                        AllowedPatternConstraint apc = new AllowedPatternConstraint((String)((Map)entry.getValue()).get("allowed_pattern"));
                        apc.setDescription((String)((Map)entry.getValue()).get("description"));
                        constraints.put((String)entry.getKey(), apc);
                        break;
                    }
                    case "allowed_values": {
                        AllowedValuesConstraint avc = new AllowedValuesConstraint((Map)objMap.readValue(((Map)entry.getValue()).get("allowed_values").toString(), (TypeReference)new TypeReference<Map<String, String>>(){}));
                        avc.setDescription((String)((Map)entry.getValue()).get("description"));
                        constraints.put((String)entry.getKey(), avc);
                        break;
                    }
                    case "length": {
                        LengthConstraint lc = new LengthConstraint((Map)objMap.readValue(((Map)entry.getValue()).get("limits").toString(), (TypeReference)new TypeReference<Map<String, Integer>>(){}), (String)((Map)entry.getValue()).get("description"));
                        constraints.put((String)entry.getKey(), lc);
                        break;
                    }
                    case "range": {
                        RangeConstraint rc = new RangeConstraint((Map)objMap.readValue(((Map)entry.getValue()).get("limits").toString(), (TypeReference)new TypeReference<Map<String, Double>>(){}), (String)((Map)entry.getValue()).get("description"));
                        constraints.put((String)entry.getKey(), rc);
                        break;
                    }
                    case "custom_constraint": {
                        CustomConstraint cc = new CustomConstraint((String)((Map)entry.getValue()).get("key"));
                        cc.setDescription((String)((Map)entry.getValue()).get("description"));
                        constraints.put((String)entry.getKey(), cc);
                    }
                }
            }
        }
        return constraints;
    }
}

