/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.configuration;

import com.arkea.jenkins.openstack.client.OpenStack4jClient;
import com.arkea.jenkins.openstack.exception.utils.ExceptionUtils;
import com.arkea.jenkins.openstack.exception.utils.FormExceptionUtils;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProjectOS
implements Describable<ProjectOS> {
    private String project;
    private String url;
    private boolean checkV3;
    private String domain;
    private String user;
    private Secret password;
    private String region;

    @DataBoundConstructor
    public ProjectOS(String project, String url, JSONObject v3, String user, Secret password, String region) {
        this.project = project;
        this.url = url;
        if (v3 != null) {
            this.checkV3 = true;
            this.domain = v3.getString("domain");
        }
        this.user = user;
        this.password = password;
        this.region = region;
    }

    public ProjectOS(String project, String url, boolean checkV3, String domain, String user, Secret password, String region) {
        this.project = project;
        this.url = url;
        this.checkV3 = checkV3;
        this.domain = domain;
        this.user = user;
        this.password = password;
        this.region = region;
    }

    public ProjectOS(JSONObject project) {
        this.project = project.getString("project");
        this.url = project.getString("url");
        this.checkV3 = project.getBoolean("v3");
        this.domain = project.getString("domain");
        this.user = project.getString("user");
        this.password = Secret.fromString((String)project.getString("password"));
        this.region = project.getString("region");
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isCheckV3() {
        return this.checkV3;
    }

    public void setCheckV3(boolean checkV3) {
        this.checkV3 = checkV3;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Secret getPassword() {
        return this.password;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean checkData() throws Descriptor.FormException {
        if (Strings.isNullOrEmpty((String)this.project)) {
            throw FormExceptionUtils.getFormException(Messages.project_label(), Messages.project_name());
        }
        if (Strings.isNullOrEmpty((String)this.url)) {
            throw FormExceptionUtils.getFormException(Messages.url_label(), Messages.url_name());
        }
        if (this.isCheckV3() && Strings.isNullOrEmpty((String)this.domain)) {
            throw FormExceptionUtils.getFormException(Messages.domain_label(), Messages.domain_name());
        }
        if (Strings.isNullOrEmpty((String)this.user)) {
            throw FormExceptionUtils.getFormException(Messages.user_label(), Messages.user_name());
        }
        if (Strings.isNullOrEmpty((String)Secret.toString((Secret)this.password))) {
            throw FormExceptionUtils.getFormException(Messages.password_label(), Messages.password_name());
        }
        return true;
    }

    public Descriptor<ProjectOS> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public JSONObject toJSON() {
        return new JSONObject().accumulate("project", (Object)this.getProject()).accumulate("url", (Object)this.getUrl()).accumulate("v3", this.isCheckV3()).accumulate("domain", (Object)this.getDomain()).accumulate("user", (Object)this.getUser()).accumulate("password", (Object)this.getPassword().getEncryptedValue()).accumulate("region", (Object)this.region);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ProjectOS> {
        public String getDisplayName() {
            return "Project Openstack Configuration Pojo";
        }

        public FormValidation doTestConnection(@QueryParameter(value="project") String project, @QueryParameter(value="url") String url, @QueryParameter(value="v3") boolean v3, @QueryParameter(value="domain") String domain, @QueryParameter(value="user") String user, @QueryParameter(value="password") Secret password, @QueryParameter(value="region") String region) throws Descriptor.FormException {
            try {
                StringBuilder msg = new StringBuilder();
                if (Strings.isNullOrEmpty((String)project)) {
                    msg.append(Messages.input_filled(Messages.project_label()));
                }
                if (Strings.isNullOrEmpty((String)url)) {
                    msg.append(Messages.input_filled(Messages.url_label()));
                }
                if (v3 && Strings.isNullOrEmpty((String)domain)) {
                    msg.append(Messages.input_filled(Messages.domain_label()));
                }
                if (Strings.isNullOrEmpty((String)user)) {
                    msg.append(Messages.input_filled(Messages.user_label()));
                }
                if (Strings.isNullOrEmpty((String)Secret.toString((Secret)password))) {
                    msg.append(Messages.input_filled(Messages.password_label()));
                }
                if (msg.length() > 0) {
                    return FormValidation.warning((String)msg.toString());
                }
                OpenStack4jClient client = new OpenStack4jClient(new ProjectOS(project, url, v3, domain, user, password, region));
                if (client.isConnectionOK()) {
                    return FormValidation.ok((String)Messages.formValidation_success());
                }
                return FormValidation.error((String)Messages.formValidation_errorConnect());
            }
            catch (Exception e) {
                return FormValidation.error((String)(Messages.formValidation_errorClient() + e.getMessage() + ExceptionUtils.getStackTrace(e)));
            }
        }
    }
}

