/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.client;

import com.arkea.jenkins.openstack.heat.configuration.ProjectOS;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.heat.HeatService;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.model.heat.Event;
import org.openstack4j.model.heat.Stack;
import org.openstack4j.model.heat.StackCreate;
import org.openstack4j.model.heat.builder.StackCreateBuilder;
import org.openstack4j.openstack.OSFactory;
import org.openstack4j.openstack.heat.domain.HeatStackCreate;

public class OpenStack4jClient {
    private HeatService heatService;

    public OpenStack4jClient(ProjectOS projectOS) {
        OSClient osClient = null;
        osClient = projectOS.isCheckV3() ? (OSClient)((IOSClientBuilder.V3)OSFactory.builderV3().endpoint(projectOS.getUrl())).credentials(projectOS.getUser(), projectOS.getPassword().getPlainText(), Identifier.byName((String)projectOS.getDomain())).scopeToProject(Identifier.byName((String)projectOS.getProject()), Identifier.byName((String)projectOS.getDomain())).authenticate() : (OSClient)((IOSClientBuilder.V2)((IOSClientBuilder.V2)OSFactory.builderV2().endpoint(projectOS.getUrl())).credentials(projectOS.getUser(), projectOS.getPassword().getPlainText())).tenantName(projectOS.getProject()).authenticate();
        this.heatService = Strings.isNullOrEmpty((String)projectOS.getRegion()) ? osClient.heat() : osClient.useRegion(projectOS.getRegion()).heat();
    }

    public List<? extends Stack> getStacks() {
        return this.heatService.stacks().list();
    }

    public Stack createStack(String stackName, String fullName, String tags, Map<String, String> params, String fullEnvFile, long timeout) {
        StackCreateBuilder builder = !Strings.isNullOrEmpty((String)tags) ? Builders.stack().name(stackName).tags(tags).parameters(params).templateFromFile(fullName).disableRollback(false).timeoutMins(Long.valueOf(timeout)) : Builders.stack().name(stackName).parameters(params).templateFromFile(fullName).disableRollback(false).timeoutMins(Long.valueOf(timeout));
        if (!Strings.isNullOrEmpty((String)fullEnvFile)) {
            builder.environmentFromFile(fullEnvFile);
        }
        HeatStackCreate stack = (HeatStackCreate)builder.build();
        return this.getDetails(stackName, this.heatService.stacks().create((StackCreate)stack).getId());
    }

    public Stack getStackByName(String stackName) {
        return this.heatService.stacks().getStackByName(stackName);
    }

    public Stack getDetails(String stackName, String stackId) {
        return this.heatService.stacks().getDetails(stackName, stackId);
    }

    public void deleteStack(Stack stack) {
        this.heatService.stacks().delete(stack.getName(), stack.getId());
    }

    public boolean isConnectionOK() {
        boolean rtn = true;
        try {
            this.heatService.stacks().list();
        }
        catch (Exception e) {
            rtn = false;
        }
        return rtn;
    }

    public List<? extends Event> getEvents(Stack stack) {
        return this.heatService.events().list(stack.getName(), stack.getId());
    }
}

