/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Collection;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.UserDataVariableResolver;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataConfig
extends Config {
    @DataBoundConstructor
    public UserDataConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.getActiveInstance().getDescriptorByType(UserDataConfigProvider.class);
    }

    @Extension(ordinal=70.0)
    public static class UserDataConfigProvider
    extends AbstractConfigProviderImpl {
        public UserDataConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return ContentType.DefinedType.HTML;
        }

        public String getDisplayName() {
            return "OpenStack User Data";
        }

        @NonNull
        public Config newConfig(@NonNull String id) {
            return new UserDataConfig(id, "UserData", "", "");
        }

        public Config convert(Config config) {
            return new UserDataConfig(config.id, config.name, config.comment, config.content);
        }

        @Restricted(value={DoNotUse.class})
        public Collection<UserDataVariableResolver.Entry> getVariables() {
            return UserDataVariableResolver.STUB.values();
        }

        @Restricted(value={DoNotUse.class})
        public Collection<String> usages(@NonNull String id) {
            ArrayList<String> usages = new ArrayList<String>();
            for (JCloudsCloud cloud : JCloudsCloud.getClouds()) {
                for (JCloudsSlaveTemplate template : cloud.getTemplates()) {
                    if (!id.equals(template.getEffectiveSlaveOptions().getUserDataId())) continue;
                    usages.add(cloud.name + " / " + template.name);
                }
            }
            return usages;
        }
    }
}

